/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;

public class SVNConsoleAuthenticationProvider
implements ISVNAuthenticationProvider {
    private static final int MAX_PROMPT_COUNT = 3;
    private Map myRequestsCount = new HashMap();
    private boolean myIsTrustServerCertificate;
    static /* synthetic */ Class class$java$lang$System;

    public SVNConsoleAuthenticationProvider(boolean trustServerCertificate) {
        this.myIsTrustServerCertificate = trustServerCertificate;
    }

    public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
        if (this.myIsTrustServerCertificate) {
            return 1;
        }
        if (!(certificate instanceof X509Certificate)) {
            return 1;
        }
        String hostName = url.getHost();
        X509Certificate cert = (X509Certificate)certificate;
        StringBuffer prompt = SVNSSLUtil.getServerCertificatePrompt((X509Certificate)cert, (String)realm, (String)hostName);
        if (resultMayBeStored) {
            prompt.append("\n(R)eject, accept (t)emporarily or accept (p)ermanently? ");
        } else {
            prompt.append("\n(R)eject or accept (t)emporarily? ");
        }
        System.err.print(prompt.toString());
        System.err.flush();
        while (true) {
            String line;
            if ((line = SVNConsoleAuthenticationProvider.readLine()) == null) {
                return 0;
            }
            if (line.length() < 1) continue;
            char ch = line.charAt(0);
            if (ch == 'R' || ch == 'r') {
                return 0;
            }
            if (ch == 't' || ch == 'T') {
                return 1;
            }
            if (resultMayBeStored && (ch == 'p' || ch == 'P')) break;
        }
        return 2;
    }

    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        Integer requestsCount = (Integer)this.myRequestsCount.get(kind + "$" + url + "$" + realm);
        if (requestsCount == null) {
            this.myRequestsCount.put(kind + "$" + url + "$" + realm, new Integer(1));
        } else {
            if (requestsCount == 3) {
                return null;
            }
            this.myRequestsCount.put(kind + "$" + url + "$" + realm, new Integer(requestsCount + 1));
        }
        if ("svn.simple".equals(kind)) {
            String name = null;
            SVNConsoleAuthenticationProvider.printRealm(realm);
            name = SVNConsoleAuthenticationProvider.prompt("Username");
            if (name == null) {
                return null;
            }
            String password = SVNConsoleAuthenticationProvider.promptPassword("Password for '" + name + "'");
            if (password == null) {
                return null;
            }
            return new SVNPasswordAuthentication(name, password, authMayBeStored);
        }
        if ("svn.ssh".equals(kind)) {
            String name = null;
            SVNConsoleAuthenticationProvider.printRealm(realm);
            name = SVNConsoleAuthenticationProvider.prompt("Username");
            if (name == null) {
                return null;
            }
            String password = SVNConsoleAuthenticationProvider.promptPassword("Password for '" + url.getHost() + "' (leave blank if you are going to use private key)");
            if (password == null) {
                return null;
            }
            if ("".equals(password)) {
                password = null;
            }
            String keyFile = null;
            String passphrase = null;
            if (password == null) {
                while (keyFile == null) {
                    keyFile = SVNConsoleAuthenticationProvider.prompt("Private key for '" + url.getHost() + "' (OpenSSH format)");
                    if ("".equals(keyFile)) continue;
                    if (keyFile == null) {
                        return null;
                    }
                    File file = new File(keyFile);
                    if (file.isFile() && file.canRead()) continue;
                    keyFile = null;
                }
                passphrase = SVNConsoleAuthenticationProvider.promptPassword("Private key passphrase [none]");
                if ("".equals(passphrase)) {
                    passphrase = null;
                } else if (passphrase == null) {
                    return null;
                }
            }
            int port = 22;
            String portValue = SVNConsoleAuthenticationProvider.prompt("Port number for '" + url.getHost() + "' [22]");
            if (portValue == null) {
                return null;
            }
            if (!"".equals(portValue)) {
                try {
                    port = Integer.parseInt(portValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (password != null) {
                return new SVNSSHAuthentication(name, password, port, authMayBeStored);
            }
            if (keyFile != null) {
                return new SVNSSHAuthentication(name, new File(keyFile), passphrase, port, authMayBeStored);
            }
        } else {
            if ("svn.username".equals(kind)) {
                String name = System.getProperty("user.name");
                if (name != null && "".equals(name.trim())) {
                    name = null;
                }
                if (name != null) {
                    return new SVNUserNameAuthentication(name, authMayBeStored);
                }
                SVNConsoleAuthenticationProvider.printRealm(realm);
                name = SVNConsoleAuthenticationProvider.prompt(!"file".equals(url.getProtocol()) ? "Author name [" + System.getProperty("user.name") + "]" : "Username [" + System.getProperty("user.name") + "]");
                if (name == null) {
                    return null;
                }
                if ("".equals(name.trim())) {
                    name = System.getProperty("user.name");
                }
                return new SVNUserNameAuthentication(name, authMayBeStored);
            }
            if ("svn.ssl".equals(kind)) {
                SVNConsoleAuthenticationProvider.printRealm(realm);
                String path = null;
                while (path == null) {
                    path = SVNConsoleAuthenticationProvider.prompt("Client certificate filename");
                    if ("".equals(path)) continue;
                    if (path == null) {
                        return null;
                    }
                    File file = new File(path);
                    if (file.isFile() && file.canRead()) continue;
                    path = null;
                }
                String password = SVNConsoleAuthenticationProvider.promptPassword("Passphrase for '" + realm + "'");
                if (password == null) {
                    return null;
                }
                if ("".equals(password)) {
                    password = null;
                }
                return new SVNSSLAuthentication(new File(path), password, authMayBeStored);
            }
        }
        return null;
    }

    private static void printRealm(String realm) {
        if (realm != null) {
            System.err.println("Authentication realm: " + realm);
            System.err.flush();
        }
    }

    private static String prompt(String label) {
        System.err.print(label + ": ");
        System.err.flush();
        return SVNConsoleAuthenticationProvider.readLine();
    }

    private static String promptPassword(String label) {
        System.err.print(label + ": ");
        System.err.flush();
        Class systemClass = class$java$lang$System == null ? (class$java$lang$System = SVNConsoleAuthenticationProvider.class$("java.lang.System")) : class$java$lang$System;
        try {
            Class<?> consoleClass;
            Method readPasswordMethod;
            Object consoleObject;
            Method consoleMethod = systemClass.getMethod("console", new Class[0]);
            if (consoleMethod != null && (consoleObject = consoleMethod.invoke(null, new Object[0])) != null && (readPasswordMethod = (consoleClass = consoleObject.getClass()).getMethod("readPassword", new Class[0])) != null) {
                Object password = readPasswordMethod.invoke(consoleObject, new Object[0]);
                if (password == null) {
                    return null;
                }
                if (password instanceof char[]) {
                    return new String((char[])password);
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return SVNConsoleAuthenticationProvider.readLine();
    }

    private static String readLine() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

