/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNCommitItem;

public class SVNCommitPacket {
    public static final SVNCommitPacket EMPTY = new SVNCommitPacket(null, new SVNCommitItem[0], null);
    private SVNCommitItem[] myCommitItems;
    private Map myLockTokens;
    private boolean[] myIsSkipped;
    private boolean myIsDisposed;

    SVNCommitPacket(SVNWCAccess wcAccess, SVNCommitItem[] items, Map lockTokens) {
        this.myCommitItems = items;
        this.myLockTokens = lockTokens;
        this.myIsSkipped = new boolean[items == null ? 0 : items.length];
        this.myIsDisposed = false;
        if (wcAccess != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].getWCAccess() != null) continue;
                items[i].setWCAccess(wcAccess);
            }
        }
    }

    public SVNCommitItem[] getCommitItems() {
        return this.myCommitItems;
    }

    public void setCommitItemSkipped(SVNCommitItem item, boolean skipped) {
        int index = this.getItemIndex(item);
        if (index >= 0 && index < this.myIsSkipped.length) {
            this.myIsSkipped[index] = skipped;
        }
    }

    public boolean isCommitItemSkipped(SVNCommitItem item) {
        int index = this.getItemIndex(item);
        if (index >= 0 && index < this.myIsSkipped.length) {
            return this.myIsSkipped[index];
        }
        return true;
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws SVNException {
        try {
            for (int i = 0; i < this.myCommitItems.length; ++i) {
                if (this.myCommitItems[i] == null || this.myCommitItems[i].getWCAccess() == null) continue;
                this.myCommitItems[i].getWCAccess().close();
            }
        }
        finally {
            this.myIsDisposed = true;
        }
    }

    private int getItemIndex(SVNCommitItem item) {
        for (int i = 0; this.myCommitItems != null && i < this.myCommitItems.length; ++i) {
            SVNCommitItem commitItem = this.myCommitItems[i];
            if (commitItem != item) continue;
            return i;
        }
        return -1;
    }

    Map getLockTokens() {
        return this.myLockTokens;
    }

    SVNCommitPacket removeSkippedItems() {
        if (this == EMPTY) {
            return EMPTY;
        }
        ArrayList<SVNCommitItem> items = new ArrayList<SVNCommitItem>();
        HashMap lockTokens = this.myLockTokens == null ? null : new HashMap(this.myLockTokens);
        for (int i = 0; this.myCommitItems != null && i < this.myCommitItems.length; ++i) {
            SVNCommitItem commitItem = this.myCommitItems[i];
            if (!this.myIsSkipped[i]) {
                items.add(commitItem);
                continue;
            }
            if (lockTokens == null) continue;
            lockTokens.remove(commitItem.getURL().toString());
        }
        SVNCommitItem[] filteredItems = items.toArray(new SVNCommitItem[items.size()]);
        return new SVNCommitPacket(null, filteredItems, lockTokens);
    }

    public String toString() {
        if (EMPTY == this) {
            return "[EMPTY]";
        }
        StringBuffer result = new StringBuffer();
        result.append("SVNCommitPacket: ");
        for (int i = 0; i < this.myCommitItems.length; ++i) {
            SVNCommitItem commitItem = this.myCommitItems[i];
            result.append("\n");
            if (commitItem.isAdded()) {
                result.append("A");
            } else if (commitItem.isDeleted()) {
                result.append("D");
            } else if (commitItem.isContentsModified()) {
                result.append("M");
            } else {
                result.append("_");
            }
            if (commitItem.isPropertiesModified()) {
                result.append("M");
            } else {
                result.append(" ");
            }
            result.append(" ");
            if (commitItem.getPath() != null) {
                result.append(commitItem.getPath());
                result.append(" ");
            }
            result.append(commitItem.getFile().getAbsolutePath());
            result.append("\n");
            result.append(commitItem.getRevision());
            result.append(" ");
            result.append(commitItem.getURL());
            if (commitItem.isCopied()) {
                result.append("\n");
                result.append("+");
                result.append(commitItem.getCopyFromURL());
            }
            if (!commitItem.isLocked()) continue;
            result.append("\n");
            result.append("LOCKED");
        }
        return result.toString();
    }
}

