/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNCleanupHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;

public class SVNWCAccess
implements ISVNEventHandler {
    public static final int INFINITE_DEPTH = -1;
    private ISVNEventHandler myEventHandler;
    private ISVNOptions myOptions;
    private Map myAdminAreas;
    private Map myCleanupHandlers;
    private File myAnchor;

    public static SVNWCAccess newInstance(ISVNEventHandler eventHandler) {
        return new SVNWCAccess(eventHandler);
    }

    private SVNWCAccess(ISVNEventHandler handler) {
        this.myEventHandler = handler;
    }

    public void setEventHandler(ISVNEventHandler handler) {
        this.myEventHandler = handler;
    }

    public ISVNEventHandler getEventHandler() {
        return this.myEventHandler;
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.myEventHandler != null) {
            this.myEventHandler.checkCancelled();
        }
    }

    public void handleEvent(SVNEvent event) throws SVNException {
        this.handleEvent(event, -1.0);
    }

    public void registerCleanupHandler(SVNAdminArea area, ISVNCleanupHandler handler) {
        if (area == null || handler == null) {
            return;
        }
        if (this.myCleanupHandlers == null) {
            this.myCleanupHandlers = new HashMap();
        }
        this.myCleanupHandlers.put(area, handler);
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        if (this.myEventHandler != null) {
            try {
                this.myEventHandler.handleEvent(event, progress);
            }
            catch (SVNException e) {
                throw e;
            }
            catch (Throwable th) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Error while dispatching event: {0}", th.getMessage());
                SVNErrorManager.error(err, th);
            }
        }
    }

    public void setOptions(ISVNOptions options) {
        this.myOptions = options;
    }

    public ISVNOptions getOptions() {
        if (this.myOptions == null) {
            this.myOptions = new DefaultSVNOptions();
        }
        return this.myOptions;
    }

    public void setAnchor(File anchor) {
        this.myAnchor = anchor;
    }

    public File getAnchor() {
        return this.myAnchor;
    }

    public SVNAdminAreaInfo openAnchor(File path, boolean writeLock, int depth) throws SVNException {
        SVNException parentError;
        SVNAdminArea targetArea;
        SVNAdminArea parentArea;
        String name;
        File parent;
        block37: {
            block36: {
                parent = path.getParentFile();
                if (parent == null) {
                    SVNAdminArea anchor = this.open(path, writeLock, depth);
                    return new SVNAdminAreaInfo(this, anchor, anchor, "");
                }
                name = path.getName();
                parentArea = null;
                targetArea = null;
                parentError = null;
                try {
                    parentArea = this.open(parent, writeLock, false, 0);
                }
                catch (SVNException svne) {
                    if (writeLock && svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                        try {
                            parentArea = this.open(parent, false, false, 0);
                        }
                        catch (SVNException svne2) {
                            throw svne;
                        }
                        parentError = svne;
                    }
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) break block36;
                    throw svne;
                }
            }
            try {
                targetArea = this.open(path, writeLock, false, depth);
            }
            catch (SVNException svne) {
                if (parentArea != null && svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) break block37;
                try {
                    this.close();
                }
                catch (SVNException svne2) {
                    // empty catch block
                }
                throw svne;
            }
        }
        if (parentArea != null && targetArea != null) {
            SVNEntry parentEntry = null;
            SVNEntry targetEntry = null;
            SVNEntry targetInParent = null;
            try {
                targetInParent = parentArea.getEntry(name, false);
                targetEntry = targetArea.getEntry(targetArea.getThisDirName(), false);
                parentEntry = parentArea.getEntry(parentArea.getThisDirName(), false);
            }
            catch (SVNException svne) {
                try {
                    this.close();
                }
                catch (SVNException svne2) {
                    // empty catch block
                }
                throw svne;
            }
            SVNURL parentURL = parentEntry != null ? parentEntry.getSVNURL() : null;
            SVNURL targetURL = targetEntry != null ? targetEntry.getSVNURL() : null;
            String encodedName = SVNEncodingUtil.uriEncode(name);
            if (targetInParent == null || parentURL != null && targetURL != null && (!parentURL.equals(targetURL.removePathTail()) || !encodedName.equals(SVNPathUtil.tail(targetURL.getURIEncodedPath())))) {
                if (this.myAdminAreas != null) {
                    this.myAdminAreas.remove(parent);
                }
                try {
                    this.doClose(parentArea, false);
                }
                catch (SVNException svne) {
                    try {
                        this.close();
                    }
                    catch (SVNException svne2) {
                        // empty catch block
                    }
                    throw svne;
                }
                parentArea = null;
            }
        }
        if (parentArea != null && parentError != null && targetArea != null) {
            if (parentError.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                try {
                    this.doClose(parentArea, false);
                }
                catch (SVNException svne) {
                    try {
                        this.close();
                    }
                    catch (SVNException svne2) {
                        // empty catch block
                    }
                    throw svne;
                }
                parentArea = null;
            } else {
                try {
                    this.close();
                }
                catch (SVNException svne) {
                    // empty catch block
                }
                throw parentError;
            }
        }
        if (targetArea == null) {
            SVNEntry targetEntry = null;
            try {
                targetEntry = parentArea.getEntry(name, false);
            }
            catch (SVNException svne) {
                try {
                    this.close();
                }
                catch (SVNException svne2) {
                    // empty catch block
                }
                throw svne;
            }
            if (targetEntry != null && targetEntry.isDirectory() && this.myAdminAreas != null) {
                this.myAdminAreas.put(path, null);
            }
        }
        SVNAdminArea anchor = parentArea != null ? parentArea : targetArea;
        SVNAdminArea target = targetArea != null ? targetArea : parentArea;
        return new SVNAdminAreaInfo(this, anchor, target, parentArea == null ? "" : name);
    }

    public SVNAdminArea open(File path, boolean writeLock, int depth) throws SVNException {
        return this.open(path, writeLock, false, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNAdminArea open(File path, boolean writeLock, boolean stealLock, int depth) throws SVNException {
        Iterator paths2;
        SVNAdminArea area;
        HashMap tmp = new HashMap();
        try {
            area = this.doOpen(path, writeLock, stealLock, depth, tmp);
            Object var8_7 = null;
            paths2 = tmp.keySet().iterator();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Iterator paths2 = tmp.keySet().iterator();
            while (paths2.hasNext()) {
                Object childPath = paths2.next();
                SVNAdminArea childArea = (SVNAdminArea)tmp.get(childPath);
                this.myAdminAreas.put(childPath, childArea);
            }
            throw throwable;
        }
        while (paths2.hasNext()) {
            Object childPath = paths2.next();
            SVNAdminArea childArea = (SVNAdminArea)tmp.get(childPath);
            this.myAdminAreas.put(childPath, childArea);
        }
        return area;
    }

    public SVNAdminArea probeOpen(File path, boolean writeLock, int depth) throws SVNException {
        File dir = this.probe(path);
        if (dir == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
            SVNErrorManager.error(err);
        }
        if (!path.equals(dir)) {
            depth = 0;
        }
        SVNAdminArea adminArea = null;
        try {
            adminArea = this.open(dir, writeLock, false, depth);
        }
        catch (SVNException svne) {
            SVNFileType childKind = SVNFileType.getType(path);
            SVNErrorCode errCode = svne.getErrorMessage().getErrorCode();
            if (!path.equals(dir) && childKind == SVNFileType.DIRECTORY && errCode == SVNErrorCode.WC_NOT_DIRECTORY) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
                SVNErrorManager.error(err);
            }
            throw svne;
        }
        return adminArea;
    }

    public SVNAdminArea probeTry(File path, boolean writeLock, int depth) throws SVNException {
        SVNAdminArea adminArea;
        block6: {
            adminArea = null;
            try {
                adminArea = this.probeRetrieve(path);
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    try {
                        adminArea = this.probeOpen(path, writeLock, depth);
                    }
                    catch (SVNException svne2) {
                        if (svne2.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                            throw svne2;
                        }
                        break block6;
                    }
                }
                throw svne;
            }
        }
        return adminArea;
    }

    public void close() throws SVNException {
        if (this.myAdminAreas != null) {
            this.doClose(this.myAdminAreas, false);
            this.myAdminAreas.clear();
        }
        this.myCleanupHandlers = null;
    }

    public void closeAdminArea(File path) throws SVNException {
        SVNAdminArea area;
        if (this.myAdminAreas != null && (area = (SVNAdminArea)this.myAdminAreas.get(path)) != null) {
            this.doClose(area, false);
            this.myAdminAreas.remove(path);
        }
    }

    private SVNAdminArea doOpen(File path, boolean writeLock, boolean stealLock, int depth, Map tmp) throws SVNException {
        Map map = tmp = tmp == null ? new HashMap() : tmp;
        if (this.myAdminAreas != null) {
            SVNAdminArea existing = (SVNAdminArea)this.myAdminAreas.get(path);
            if (this.myAdminAreas.containsKey(path) && existing != null) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked", path);
                SVNErrorManager.error(error);
            }
        } else {
            this.myAdminAreas = new HashMap();
        }
        SVNAdminArea area = SVNAdminAreaFactory.open(path);
        area.setWCAccess(this);
        if (writeLock) {
            area.lock(stealLock);
            area = SVNAdminAreaFactory.upgrade(area);
        }
        tmp.put(path, area);
        if (depth != 0) {
            if (depth > 0) {
                --depth;
            }
            Iterator entries = area.entries(false);
            while (entries.hasNext()) {
                try {
                    this.checkCancelled();
                }
                catch (SVNCancelException e) {
                    this.doClose(tmp, false);
                    throw e;
                }
                SVNEntry entry = (SVNEntry)entries.next();
                if (entry.getKind() != SVNNodeKind.DIR || area.getThisDirName().equals(entry.getName())) continue;
                File childPath = new File(path, entry.getName());
                try {
                    this.doOpen(childPath, writeLock, stealLock, depth, tmp);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                        this.doClose(tmp, false);
                        throw e;
                    }
                    tmp.put(childPath, null);
                }
            }
        }
        return area;
    }

    private void doClose(Map adminAreas, boolean preserveLocks) throws SVNException {
        Iterator paths = adminAreas.keySet().iterator();
        while (paths.hasNext()) {
            File path = (File)paths.next();
            SVNAdminArea adminArea = (SVNAdminArea)adminAreas.get(path);
            if (adminArea == null) {
                paths.remove();
                continue;
            }
            this.doClose(adminArea, preserveLocks);
            paths.remove();
        }
    }

    private void doClose(SVNAdminArea adminArea, boolean preserveLocks) throws SVNException {
        ISVNCleanupHandler handler;
        if (adminArea == null) {
            return;
        }
        if (this.myCleanupHandlers != null && (handler = (ISVNCleanupHandler)this.myCleanupHandlers.remove(adminArea)) != null) {
            handler.cleanup(adminArea);
        }
        if (!preserveLocks && adminArea.isLocked()) {
            adminArea.unlock();
        }
    }

    public SVNAdminArea probeRetrieve(File path) throws SVNException {
        File dir = this.probe(path);
        if (dir == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
            SVNErrorManager.error(err);
        }
        return this.retrieve(dir);
    }

    public boolean isMissing(File path) {
        if (this.myAdminAreas != null) {
            return this.myAdminAreas.containsKey(path) && this.myAdminAreas.get(path) == null;
        }
        return false;
    }

    public boolean isLocked(File path) throws SVNException {
        File lockFile = new File(path, SVNFileUtil.getAdminDirectoryName());
        if (SVNFileType.getType(lockFile = new File(lockFile, "lock")) == SVNFileType.FILE) {
            return true;
        }
        if (SVNFileType.getType(lockFile) == SVNFileType.NONE) {
            return false;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Lock file ''{0}'' is not a regular file", lockFile);
        SVNErrorManager.error(err);
        return false;
    }

    public boolean isWCRoot(File path) throws SVNException {
        SVNEntry parentEntry;
        SVNEntry entry = this.getEntry(path, false);
        if (path.getParentFile() == null && entry != null) {
            return true;
        }
        SVNAdminArea parentArea = this.getAdminArea(path.getParentFile());
        if (parentArea == null) {
            try {
                parentArea = this.probeOpen(path.getParentFile(), false, 0);
            }
            catch (SVNException svne) {
                return true;
            }
        }
        if ((parentEntry = this.getEntry(path.getParentFile(), false)) == null) {
            return true;
        }
        if (parentEntry.getURL() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no ancestry information", path.getParentFile());
            SVNErrorManager.error(err);
        }
        return (entry = parentArea.getEntry(path.getName(), false)) == null;
    }

    public SVNEntry getEntry(File path, boolean showHidden) throws SVNException {
        SVNAdminArea adminArea = this.getAdminArea(path);
        String entryName = null;
        if (adminArea == null) {
            adminArea = this.getAdminArea(path.getParentFile());
            entryName = path.getName();
        } else {
            entryName = adminArea.getThisDirName();
        }
        if (adminArea != null) {
            return adminArea.getEntry(entryName, showHidden);
        }
        return null;
    }

    public void setRepositoryRoot(File path, SVNURL reposRoot) throws SVNException {
        SVNEntry entry = this.getEntry(path, false);
        if (entry == null) {
            return;
        }
        SVNAdminArea adminArea = null;
        String name = null;
        if (entry.isFile()) {
            adminArea = this.getAdminArea(path.getParentFile());
            name = path.getName();
        } else {
            adminArea = this.getAdminArea(path);
            String string = name = adminArea != null ? adminArea.getThisDirName() : null;
        }
        if (adminArea == null) {
            return;
        }
        if (adminArea.tweakEntry(name, null, reposRoot.toString(), -1L, false)) {
            adminArea.saveEntries(false);
        }
    }

    public SVNAdminArea[] getAdminAreas() {
        if (this.myAdminAreas != null) {
            return this.myAdminAreas.values().toArray(new SVNAdminArea[this.myAdminAreas.size()]);
        }
        return new SVNAdminArea[0];
    }

    public SVNAdminArea retrieve(File path) throws SVNException {
        SVNAdminArea adminArea = this.getAdminArea(path);
        if (adminArea == null) {
            SVNErrorMessage err;
            SVNEntry subEntry = null;
            try {
                SVNAdminArea dirAdminArea = this.getAdminArea(path.getParentFile());
                if (dirAdminArea != null) {
                    subEntry = dirAdminArea.getEntry(path.getName(), true);
                }
            }
            catch (SVNException svne) {
                subEntry = null;
            }
            SVNFileType type = SVNFileType.getType(path);
            if (subEntry != null) {
                SVNErrorMessage err2;
                if (subEntry.getKind() == SVNNodeKind.DIR && type == SVNFileType.FILE) {
                    err2 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Expected ''{0}'' to be a directory but found a file", path);
                    SVNErrorManager.error(err2);
                } else if (subEntry.getKind() == SVNNodeKind.FILE && type == SVNFileType.DIRECTORY) {
                    err2 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Expected ''{0}'' to be a file but found a directory", path);
                    SVNErrorManager.error(err2);
                }
            }
            File adminDir = new File(path, SVNFileUtil.getAdminDirectoryName());
            SVNFileType wcType = SVNFileType.getType(adminDir);
            if (type == SVNFileType.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Directory ''{0}'' is missing", path);
                SVNErrorManager.error(err);
            } else if (type == SVNFileType.DIRECTORY && wcType == SVNFileType.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Directory ''{0}'' containing working copy admin area is missing", adminDir);
                SVNErrorManager.error(err);
            } else if (type == SVNFileType.DIRECTORY && wcType == SVNFileType.DIRECTORY) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Unable to lock ''{0}''", path);
                SVNErrorManager.error(err);
            }
            err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy ''{0}'' is not locked", path);
            SVNErrorManager.error(err);
        }
        return adminArea;
    }

    public static SVNExternalInfo[] parseExternals(String rootPath, String externals) {
        ArrayList<SVNExternalInfo> result = new ArrayList<SVNExternalInfo>();
        if (externals == null) {
            return result.toArray(new SVNExternalInfo[result.size()]);
        }
        StringTokenizer lines = new StringTokenizer(externals, "\n\r");
        while (lines.hasMoreTokens()) {
            String revStr;
            String line = lines.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#")) continue;
            String url = null;
            long rev = -1L;
            ArrayList<String> parts = new ArrayList<String>(4);
            StringTokenizer tokens = new StringTokenizer(line, " \t");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                parts.add(token);
            }
            if (parts.size() < 2) continue;
            String path = SVNPathUtil.append(rootPath, (String)parts.get(0));
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (parts.size() == 2) {
                url = (String)parts.get(1);
            } else if (parts.size() == 3 && parts.get(1).toString().startsWith("-r")) {
                revStr = parts.get(1).toString();
                if (!"HEAD".equals(revStr = revStr.substring("-r".length()))) {
                    try {
                        rev = Long.parseLong(revStr);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                }
                url = (String)parts.get(2);
            } else if (parts.size() == 4 && "-r".equals(parts.get(1))) {
                revStr = parts.get(2).toString();
                if (!"HEAD".equals(revStr)) {
                    try {
                        rev = Long.parseLong(revStr);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                }
                url = (String)parts.get(3);
            }
            if (path == null || url == null) continue;
            if ("".equals(rootPath) && ((String)parts.get(0)).startsWith("/")) {
                path = "/" + path;
            }
            try {
                url = SVNURL.parseURIEncoded(url).toString();
            }
            catch (SVNException e) {
                continue;
            }
            try {
                SVNExternalInfo info = new SVNExternalInfo("", null, path, SVNURL.parseURIEncoded(url), rev);
                result.add(info);
            }
            catch (SVNException e) {}
        }
        return result.toArray(new SVNExternalInfo[result.size()]);
    }

    public SVNAdminArea getAdminArea(File path) {
        SVNAdminArea adminArea = null;
        if (this.myAdminAreas != null) {
            adminArea = (SVNAdminArea)this.myAdminAreas.get(path);
        }
        return adminArea;
    }

    private File probe(File path) throws SVNException {
        int wcFormat = -1;
        SVNFileType type = SVNFileType.getType(path);
        wcFormat = type == SVNFileType.DIRECTORY ? SVNAdminAreaFactory.checkWC(path, true) : 0;
        if (type != SVNFileType.DIRECTORY || wcFormat == 0) {
            if ("..".equals(path.getName()) || ".".equals(path.getName())) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_BAD_PATH, "Path ''{0}'' ends in ''{1}'', which is unsupported for this operation", new Object[]{path, path.getName()});
                SVNErrorManager.error(err);
            }
            path = path.getParentFile();
        }
        return path;
    }
}

