/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.util.ISVNDebugLog;

public class SVNReporter
implements ISVNReporterBaton {
    private SVNAdminAreaInfo myInfo;
    private boolean myIsRecursive;
    private boolean myIsRestore;
    private File myTarget;
    private ISVNDebugLog myLog;

    public SVNReporter(SVNAdminAreaInfo info, File file, boolean restoreFiles, boolean recursive, ISVNDebugLog log) {
        this.myInfo = info;
        this.myIsRecursive = recursive;
        this.myIsRestore = restoreFiles;
        this.myLog = log;
        this.myTarget = file;
    }

    public void report(ISVNReporter reporter) throws SVNException {
        try {
            boolean missing;
            SVNAdminArea targetArea = this.myInfo.getTarget();
            SVNWCAccess wcAccess = this.myInfo.getWCAccess();
            SVNEntry targetEntry = wcAccess.getEntry(this.myTarget, false);
            if (targetEntry == null || targetEntry.isDirectory() && targetEntry.isScheduledForAddition()) {
                SVNEntry parentEntry = wcAccess.getEntry(this.myTarget.getParentFile(), false);
                long revision = parentEntry.getRevision();
                reporter.setPath("", null, revision, targetEntry != null ? targetEntry.isIncomplete() : true);
                reporter.deletePath("");
                reporter.finishReport();
                return;
            }
            SVNEntry parentEntry = null;
            long revision = targetEntry.getRevision();
            if (revision < 0L) {
                parentEntry = wcAccess.getEntry(this.myTarget.getParentFile(), false);
                if (parentEntry == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", this.myTarget.getParentFile());
                    SVNErrorManager.error(err);
                }
                revision = parentEntry.getRevision();
            }
            reporter.setPath("", null, revision, targetEntry.isIncomplete());
            SVNFileType fileType = SVNFileType.getType(this.myTarget);
            boolean bl = missing = !targetEntry.isScheduledForDeletion() && fileType == SVNFileType.NONE;
            if (targetEntry.isDirectory()) {
                if (missing) {
                    reporter.deletePath("");
                } else {
                    this.reportEntries(reporter, targetArea, "", revision, targetEntry.isIncomplete(), this.myIsRecursive);
                }
            } else if (targetEntry.isFile()) {
                if (missing) {
                    this.restoreFile(targetArea, targetEntry.getName());
                }
                parentEntry = parentEntry == null ? wcAccess.getEntry(this.myTarget.getParentFile(), false) : parentEntry;
                String url = targetEntry.getURL();
                String parentURL = parentEntry.getURL();
                String expectedURL = SVNPathUtil.append(parentURL, SVNEncodingUtil.uriEncode(targetEntry.getName()));
                if (parentEntry != null && !expectedURL.equals(url)) {
                    SVNURL svnURL = SVNURL.parseURIEncoded(url);
                    reporter.linkPath(svnURL, "", targetEntry.getLockToken(), targetEntry.getRevision(), false);
                } else if (targetEntry.getRevision() != revision || targetEntry.getLockToken() != null) {
                    reporter.setPath("", targetEntry.getLockToken(), targetEntry.getRevision(), false);
                }
            }
            reporter.finishReport();
        }
        catch (SVNException e) {
            try {
                reporter.abortReport();
            }
            catch (SVNException inner) {
                this.myLog.info(inner);
            }
            throw e;
        }
        catch (Throwable th) {
            this.myLog.info(th);
            try {
                reporter.abortReport();
            }
            catch (SVNException e) {
                this.myLog.info(e);
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "WC report failed: {0}", th.getMessage());
            SVNErrorManager.error(err, th);
        }
    }

    private void reportEntries(ISVNReporter reporter, SVNAdminArea adminArea, String dirPath, long dirRevision, boolean reportAll, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.myInfo.getWCAccess();
        SVNExternalInfo[] externals = this.myInfo.addExternals(adminArea, adminArea.getProperties(adminArea.getThisDirName()).getPropertyValue("svn:externals"));
        for (int i = 0; externals != null && i < externals.length; ++i) {
            externals[i].setOldExternal(externals[i].getNewURL(), externals[i].getNewRevision());
        }
        String parentURL = adminArea.getEntry(adminArea.getThisDirName(), true).getURL();
        Iterator e = adminArea.entries(true);
        while (e.hasNext()) {
            SVNURL svnURL;
            String path;
            SVNEntry entry = (SVNEntry)e.next();
            if (adminArea.getThisDirName().equals(entry.getName())) continue;
            String string = path = "".equals(dirPath) ? entry.getName() : SVNPathUtil.append(dirPath, entry.getName());
            if (entry.isDeleted() || entry.isAbsent()) {
                if (reportAll) continue;
                reporter.deletePath(path);
                continue;
            }
            if (entry.isScheduledForAddition()) continue;
            File file = adminArea.getFile(entry.getName());
            SVNFileType fileType = SVNFileType.getType(file);
            boolean missing = fileType == SVNFileType.NONE;
            String expectedURL = SVNPathUtil.append(parentURL, SVNEncodingUtil.uriEncode(entry.getName()));
            if (entry.isFile()) {
                SVNURL svnURL2;
                if (missing && !entry.isScheduledForDeletion() && !entry.isScheduledForReplacement()) {
                    this.restoreFile(adminArea, entry.getName());
                }
                String url = entry.getURL();
                if (reportAll) {
                    if (!url.equals(expectedURL)) {
                        svnURL2 = SVNURL.parseURIEncoded(url);
                        reporter.linkPath(svnURL2, path, entry.getLockToken(), entry.getRevision(), false);
                        continue;
                    }
                    reporter.setPath(path, entry.getLockToken(), entry.getRevision(), false);
                    continue;
                }
                if (!entry.isScheduledForReplacement() && !url.equals(expectedURL)) {
                    svnURL2 = SVNURL.parseURIEncoded(url);
                    reporter.linkPath(svnURL2, path, entry.getLockToken(), entry.getRevision(), false);
                    continue;
                }
                if (entry.getRevision() == dirRevision && entry.getLockToken() == null) continue;
                reporter.setPath(path, entry.getLockToken(), entry.getRevision(), false);
                continue;
            }
            if (!entry.isDirectory() || !recursive) continue;
            if (missing) {
                if (this.myIsRestore && entry.isScheduledForDeletion() || entry.isScheduledForReplacement()) {
                    entry.setSchedule(null);
                    adminArea.saveEntries(false);
                }
                if (reportAll) continue;
                reporter.deletePath(path);
                continue;
            }
            SVNAdminArea childArea = wcAccess.retrieve(adminArea.getFile(entry.getName()));
            SVNEntry childEntry = childArea.getEntry(childArea.getThisDirName(), true);
            String url = childEntry.getURL();
            if (reportAll) {
                if (!url.equals(expectedURL)) {
                    svnURL = SVNURL.parseURIEncoded(url);
                    reporter.linkPath(svnURL, path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.isIncomplete());
                } else {
                    reporter.setPath(path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.isIncomplete());
                }
            } else if (!url.equals(expectedURL)) {
                svnURL = SVNURL.parseURIEncoded(url);
                reporter.linkPath(svnURL, path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.isIncomplete());
            } else if (childEntry.getLockToken() != null || childEntry.getRevision() != dirRevision || childEntry.isIncomplete()) {
                reporter.setPath(path, childEntry.getLockToken(), childEntry.getRevision(), childEntry.isIncomplete());
            }
            this.reportEntries(reporter, childArea, path, childEntry.getRevision(), childEntry.isIncomplete(), recursive);
        }
    }

    private void restoreFile(SVNAdminArea adminArea, String name) throws SVNException {
        if (!this.myIsRestore) {
            return;
        }
        adminArea.restoreFile(name);
        SVNEntry entry = adminArea.getEntry(name, true);
        this.myInfo.getWCAccess().handleEvent(SVNEventFactory.createRestoredEvent(this.myInfo, adminArea, entry));
    }
}

