/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.ISVNPropertyComparator;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNProperties {
    public static final String SVN_HASH_TERMINATOR = "END";
    private File myFile;
    private String myPath;

    public SVNProperties(File properitesFile, String path) {
        this.myFile = properitesFile;
        this.myPath = path;
    }

    public File getFile() {
        return this.myFile;
    }

    public String getPath() {
        return this.myPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection properties(Collection target) throws SVNException {
        Collection collection = target = target == null ? new TreeSet() : target;
        if (this.isEmpty()) {
            return target;
        }
        ByteArrayOutputStream nameOS = new ByteArrayOutputStream();
        InputStream is = SVNFileUtil.openFileForReading(this.getFile());
        try {
            while (SVNProperties.readProperty('K', is, nameOS)) {
                target.add(new String(nameOS.toByteArray(), "UTF-8"));
                nameOS.reset();
                SVNProperties.readProperty('V', is, null);
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map asMap() throws SVNException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.isEmpty()) {
            return result;
        }
        ByteArrayOutputStream nameOS = new ByteArrayOutputStream();
        InputStream is = SVNFileUtil.openFileForReading(this.getFile());
        try {
            while (SVNProperties.readProperty('K', is, nameOS)) {
                String name = new String(nameOS.toByteArray(), "UTF-8");
                nameOS.reset();
                SVNProperties.readProperty('V', is, nameOS);
                String value = new String(nameOS.toByteArray(), "UTF-8");
                result.put(name, value);
                nameOS.reset();
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read properties file ''{0}'': {1}", new Object[]{this.getFile(), e.getLocalizedMessage()});
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compareTo(SVNProperties properties, ISVNPropertyComparator comparator) throws SVNException {
        boolean equals = true;
        Collection props1 = this.properties(null);
        Collection props2 = properties.properties(null);
        TreeSet tmp = new TreeSet(props1);
        tmp.removeAll(props2);
        Iterator props = tmp.iterator();
        while (props.hasNext()) {
            String missing = (String)props.next();
            comparator.propertyDeleted(missing);
            equals = false;
        }
        tmp = new TreeSet(props2);
        tmp.removeAll(props1);
        File tmpFile = null;
        File tmpFile1 = null;
        File tmpFile2 = null;
        OutputStream os = null;
        InputStream is = null;
        InputStream is1 = null;
        InputStream is2 = null;
        Iterator props3 = tmp.iterator();
        while (props3.hasNext()) {
            Object var17_16;
            String added = (String)props3.next();
            try {
                tmpFile = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp");
                os = SVNFileUtil.openFileForWriting(tmpFile);
                properties.getPropertyValue(added, os);
                SVNFileUtil.closeFile(os);
                is = SVNFileUtil.openFileForReading(tmpFile);
                comparator.propertyAdded(added, is, (int)tmpFile.length());
                equals = false;
                SVNFileUtil.closeFile(is);
                var17_16 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
            catch (Throwable throwable) {
                var17_16 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                tmpFile = null;
                is = null;
                os = null;
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
            tmpFile = null;
            is = null;
            os = null;
        }
        props2.retainAll(props1);
        Iterator props4 = props2.iterator();
        while (props4.hasNext()) {
            Object var19_22;
            String changed = (String)props4.next();
            try {
                block21: {
                    try {
                        tmpFile1 = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp1");
                        tmpFile2 = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp2");
                        os = new FileOutputStream(tmpFile1);
                        this.getPropertyValue(changed, os);
                        os.close();
                        os = new FileOutputStream(tmpFile2);
                        properties.getPropertyValue(changed, os);
                        os.close();
                        if (tmpFile2.length() != tmpFile1.length()) {
                            is = SVNFileUtil.openFileForReading(tmpFile2);
                            comparator.propertyChanged(changed, is, (int)tmpFile2.length());
                            equals = false;
                            SVNFileUtil.closeFile(is);
                            break block21;
                        }
                        is1 = SVNFileUtil.openFileForReading(tmpFile1);
                        is2 = SVNFileUtil.openFileForReading(tmpFile2);
                        boolean differs = false;
                        int i = 0;
                        while ((long)i < tmpFile1.length()) {
                            if (is1.read() != is2.read()) {
                                differs = true;
                                break;
                            }
                            ++i;
                        }
                        SVNFileUtil.closeFile(is1);
                        SVNFileUtil.closeFile(is2);
                        if (!differs) break block21;
                        is2 = SVNFileUtil.openFileForReading(tmpFile2);
                        comparator.propertyChanged(changed, is2, (int)tmpFile2.length());
                        equals = false;
                        SVNFileUtil.closeFile(is2);
                    }
                    catch (IOException e) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                        SVNErrorManager.error(err, e);
                        var19_22 = null;
                        if (tmpFile2 != null) {
                            tmpFile2.delete();
                        }
                        if (tmpFile2 != null) {
                            tmpFile1.delete();
                        }
                        SVNFileUtil.closeFile(os);
                        SVNFileUtil.closeFile(is);
                        SVNFileUtil.closeFile(is1);
                        SVNFileUtil.closeFile(is2);
                        os = null;
                        tmpFile2 = null;
                        tmpFile1 = null;
                        is2 = null;
                        is1 = null;
                        is = null;
                        continue;
                    }
                }
                var19_22 = null;
                if (tmpFile2 != null) {
                    tmpFile2.delete();
                }
            }
            catch (Throwable throwable) {
                var19_22 = null;
                if (tmpFile2 != null) {
                    tmpFile2.delete();
                }
                if (tmpFile2 != null) {
                    tmpFile1.delete();
                }
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                SVNFileUtil.closeFile(is1);
                SVNFileUtil.closeFile(is2);
                os = null;
                tmpFile2 = null;
                tmpFile1 = null;
                is2 = null;
                is1 = null;
                is = null;
                throw throwable;
            }
            if (tmpFile2 != null) {
                tmpFile1.delete();
            }
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
            SVNFileUtil.closeFile(is1);
            SVNFileUtil.closeFile(is2);
            os = null;
            tmpFile2 = null;
            tmpFile1 = null;
            is2 = null;
            is1 = null;
            is = null;
        }
        return equals;
    }

    public String getPropertyValue(String name) throws SVNException {
        if (this.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if ((os = (ByteArrayOutputStream)this.getPropertyValue(name, os)) != null && os.size() >= 0) {
            byte[] bytes = os.toByteArray();
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(bytes);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getPropertyValue(String name, OutputStream os) throws SVNException {
        if (this.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream nameOS = new ByteArrayOutputStream();
        InputStream is = SVNFileUtil.openFileForReading(this.getFile());
        try {
            while (SVNProperties.readProperty('K', is, nameOS)) {
                String currentName = new String(nameOS.toByteArray(), "UTF-8");
                nameOS.reset();
                if (currentName.equals(name)) {
                    SVNProperties.readProperty('V', is, os);
                    OutputStream outputStream = os;
                    return outputStream;
                }
                SVNProperties.readProperty('V', is, null);
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return null;
    }

    public void setPropertyValue(String name, String value) throws SVNException {
        byte[] bytes = null;
        if (value != null) {
            try {
                bytes = value.getBytes("UTF-8");
            }
            catch (IOException e) {
                bytes = value.getBytes();
            }
        }
        int length = bytes != null && bytes.length >= 0 ? bytes.length : -1;
        this.setPropertyValue(name, bytes != null ? new ByteArrayInputStream(bytes) : null, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyValue(String name, InputStream is, int length) throws SVNException {
        InputStream src = null;
        OutputStream dst = null;
        File tmpFile = null;
        boolean empty = false;
        try {
            tmpFile = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp");
            if (!this.isEmpty()) {
                src = SVNFileUtil.openFileForReading(this.getFile());
            }
            empty = !SVNProperties.copyProperties(src, dst = SVNFileUtil.openFileForWriting(tmpFile), name, is, length);
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(src);
            SVNFileUtil.closeFile(dst);
            throw throwable;
        }
        SVNFileUtil.closeFile(src);
        SVNFileUtil.closeFile(dst);
        if (tmpFile != null) {
            if (!empty) {
                SVNFileUtil.rename(tmpFile, this.getFile());
                SVNFileUtil.setReadonly(this.getFile(), true);
            } else {
                SVNFileUtil.deleteFile(tmpFile);
                SVNFileUtil.deleteFile(this.getFile());
            }
        }
    }

    public void setProperties(Map properties) throws SVNException {
        if (properties != null) {
            Iterator names = properties.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                String value = (String)properties.get(name);
                this.setPropertyValue(name, value);
            }
        }
    }

    public Map compareTo(SVNProperties properties) throws SVNException {
        final HashMap locallyChangedProperties = new HashMap();
        this.compareTo(properties, new ISVNPropertyComparator(){

            public void propertyAdded(String name, InputStream value, int length) {
                this.propertyChanged(name, value, length);
            }

            public void propertyChanged(String name, InputStream newValue, int length) {
                ByteArrayOutputStream os = new ByteArrayOutputStream(length);
                for (int i = 0; i < length; ++i) {
                    try {
                        os.write(newValue.read());
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                byte[] bytes = os.toByteArray();
                try {
                    locallyChangedProperties.put(name, new String(bytes, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    locallyChangedProperties.put(name, new String(bytes));
                }
            }

            public void propertyDeleted(String name) {
                locallyChangedProperties.put(name, null);
            }
        });
        return locallyChangedProperties;
    }

    public void copyTo(SVNProperties destination) throws SVNException {
        if (this.isEmpty()) {
            SVNFileUtil.deleteFile(destination.getFile());
        } else {
            SVNFileUtil.copyFile(this.getFile(), destination.getFile(), false);
        }
    }

    public void delete() throws SVNException {
        SVNFileUtil.deleteFile(this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperties(Map namesToValues, File target, File tmpFile, String terminator) throws SVNException {
        OutputStream dst = null;
        try {
            dst = SVNFileUtil.openFileForWriting(tmpFile);
            SVNProperties.setProperties(namesToValues, dst, terminator);
        }
        finally {
            SVNFileUtil.closeFile(dst);
        }
        if (tmpFile != null) {
            SVNFileUtil.rename(tmpFile, target);
            SVNFileUtil.setReadonly(target, true);
        }
    }

    public static void setProperties(Map namesToValues, OutputStream target, String terminator) throws SVNException {
        try {
            Object[] keys = namesToValues.keySet().toArray();
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                String propertyName = (String)keys[i];
                SVNProperties.writeProperty(target, 'K', propertyName.getBytes("UTF-8"));
                String propertyValue = (String)namesToValues.get(propertyName);
                SVNProperties.writeProperty(target, 'V', propertyValue.getBytes("UTF-8"));
            }
            if (terminator != null) {
                target.write(terminator.getBytes("UTF-8"));
                target.write(10);
            }
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
    }

    public static void appendProperty(String name, String value, OutputStream target) throws SVNException {
        if (name == null || value == null) {
            return;
        }
        try {
            SVNProperties.writeProperty(target, 'K', name.getBytes("UTF-8"));
            SVNProperties.writeProperty(target, 'V', value.getBytes("UTF-8"));
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
    }

    public static void appendPropertyDeleted(String name, OutputStream target) throws SVNException {
        if (name == null) {
            return;
        }
        try {
            SVNProperties.writeProperty(target, 'D', name.getBytes("UTF-8"));
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
    }

    private static boolean copyProperties(InputStream is, OutputStream os, String name, InputStream value, int length) throws SVNException {
        int propCount = 0;
        try {
            if (is != null) {
                int l = 0;
                while ((l = SVNProperties.readLength(is, 'K')) > 0) {
                    byte[] nameBytes = new byte[l];
                    is.read(nameBytes);
                    is.read();
                    if (name.equals(new String(nameBytes, "UTF-8"))) {
                        SVNProperties.readProperty('V', is, null);
                        continue;
                    }
                    SVNProperties.writeProperty(os, 'K', nameBytes);
                    l = SVNProperties.readLength(is, 'V');
                    SVNProperties.writeProperty(os, 'V', is, l);
                    is.read();
                    ++propCount;
                }
            }
            if (value != null && length >= 0) {
                byte[] nameBytes = name.getBytes("UTF-8");
                SVNProperties.writeProperty(os, 'K', nameBytes);
                SVNProperties.writeProperty(os, 'V', value, length);
                ++propCount;
            }
            if (propCount > 0) {
                os.write(new byte[]{69, 78, 68, 10});
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        return propCount > 0;
    }

    private static boolean readProperty(char type, InputStream is, OutputStream os) throws IOException {
        int length = SVNProperties.readLength(is, type);
        if (length < 0) {
            return false;
        }
        if (os != null) {
            byte[] value = new byte[length];
            int r = is.read(value);
            os.write(value, 0, r);
        } else {
            while (length > 0) {
                length = (int)((long)length - is.skip(length));
            }
        }
        return is.read() == 10;
    }

    private static void writeProperty(OutputStream os, char type, byte[] value) throws IOException {
        os.write((byte)type);
        os.write(32);
        os.write(Integer.toString(value.length).getBytes());
        os.write(10);
        os.write(value);
        os.write(10);
    }

    private static void writeProperty(OutputStream os, char type, InputStream value, int length) throws IOException {
        os.write((byte)type);
        os.write(32);
        os.write(Integer.toString(length).getBytes());
        os.write(10);
        for (int i = 0; i < length; ++i) {
            int r = value.read();
            os.write(r);
        }
        os.write(10);
    }

    private static int readLength(InputStream is, char type) throws IOException {
        byte[] buffer = new byte[255];
        int r = is.read(buffer, 0, 4);
        if (r != 4) {
            throw new IOException("invalid properties file format");
        }
        if (buffer[0] == 69 && buffer[1] == 78 && buffer[2] == 68 && buffer[3] == 10) {
            return -1;
        }
        if (buffer[0] == type && buffer[1] == 32) {
            int i = 4;
            if (buffer[3] != 10) {
                while (true) {
                    int b;
                    if ((b = is.read()) < 0) {
                        throw new IOException("invalid properties file format");
                    }
                    if (b != 10) {
                        buffer[i] = (byte)(0xFF & b);
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                i = 3;
            }
            String length = new String(buffer, 2, i - 2);
            return Integer.parseInt(length.trim());
        }
        throw new IOException("invalid properties file format");
    }

    public boolean isEmpty() {
        return !this.getFile().exists() || this.getFile().length() <= 4L;
    }
}

