/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class FSWriteLock {
    private static final Map ourThreadLocksCache = new HashMap();
    private RandomAccessFile myLockFile;
    private FileLock myLock;
    private int myReferencesCount = 0;
    private FSFS myFSFS;
    private String myUUID;

    private FSWriteLock(String uuid, FSFS owner) {
        this.myUUID = uuid;
        this.myFSFS = owner;
    }

    public static synchronized FSWriteLock getWriteLock(FSFS owner) throws SVNException {
        String uuid = owner.getUUID();
        FSWriteLock lock = (FSWriteLock)ourThreadLocksCache.get(uuid);
        if (lock == null) {
            lock = new FSWriteLock(uuid, owner);
            ourThreadLocksCache.put(uuid, lock);
        }
        ++lock.myReferencesCount;
        return lock;
    }

    public synchronized void lock() throws SVNException {
        File writeLockFile = this.myFSFS.getWriteLockFile();
        try {
            SVNFileType type = SVNFileType.getType(writeLockFile);
            if (type == SVNFileType.UNKNOWN || type == SVNFileType.NONE) {
                SVNFileUtil.createEmptyFile(writeLockFile);
            }
            this.myLockFile = new RandomAccessFile(writeLockFile, "rw");
            this.myLock = this.myLockFile.getChannel().lock();
        }
        catch (IOException ioe) {
            this.unlock();
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can't get exclusive lock on file ''{0}'': {1}", new Object[]{writeLockFile, ioe.getLocalizedMessage()});
            SVNErrorManager.error(err, ioe);
        }
    }

    public static synchronized void realease(FSWriteLock lock) {
        if (lock == null) {
            return;
        }
        if (--lock.myReferencesCount == 0) {
            ourThreadLocksCache.remove(lock.myUUID);
        }
    }

    public synchronized void unlock() {
        if (this.myLock != null) {
            try {
                this.myLock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.myLock = null;
        }
        SVNFileUtil.closeFile(this.myLockFile);
        this.myLockFile = null;
    }
}

