/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNLocationEntry;

public class FSNodeHistory {
    private SVNLocationEntry historyEntry;
    private SVNLocationEntry searchResumeEntry;
    private boolean isInteresting;

    public FSNodeHistory(SVNLocationEntry newHistoryEntry, boolean interest, SVNLocationEntry newSearchResumeEntry) {
        this.historyEntry = newHistoryEntry;
        this.searchResumeEntry = newSearchResumeEntry;
        this.isInteresting = interest;
    }

    public SVNLocationEntry getHistoryEntry() {
        return this.historyEntry;
    }

    public void setHistoryEntry(SVNLocationEntry newHistoryEntry) {
        this.historyEntry = newHistoryEntry;
    }

    public SVNLocationEntry getSearchResumeEntry() {
        return this.searchResumeEntry;
    }

    public void setHintsEntry(SVNLocationEntry newSearchResumeEntry) {
        this.searchResumeEntry = newSearchResumeEntry;
    }

    public boolean isInteresting() {
        return this.isInteresting;
    }

    public void setInterest(boolean someInterest) {
        this.isInteresting = someInterest;
    }

    public static SVNLocationEntry findYoungestCopyroot(File reposRootDir, FSParentPath parPath) throws SVNException {
        SVNLocationEntry parentEntry = null;
        if (parPath.getParent() != null) {
            parentEntry = FSNodeHistory.findYoungestCopyroot(reposRootDir, parPath.getParent());
        }
        SVNLocationEntry myEntry = new SVNLocationEntry(parPath.getRevNode().getCopyRootRevision(), parPath.getRevNode().getCopyRootPath());
        if (parentEntry != null) {
            if (myEntry.getRevision() >= parentEntry.getRevision()) {
                return myEntry;
            }
            return parentEntry;
        }
        return myEntry;
    }

    public static boolean checkAncestryOfPegPath(String fsPath, long pegRev, long futureRev, FSFS owner) throws SVNException {
        FSRevisionRoot root = owner.createRevisionRoot(futureRev);
        FSNodeHistory history = FSNodeHistory.getNodeHistory(root, fsPath);
        fsPath = null;
        SVNLocationEntry currentHistory = null;
        while ((history = history.fsHistoryPrev(true, owner)) != null) {
            currentHistory = new SVNLocationEntry(history.getHistoryEntry().getRevision(), history.getHistoryEntry().getPath());
            if (fsPath == null) {
                fsPath = currentHistory.getPath();
            }
            if (currentHistory.getRevision() > pegRev) continue;
        }
        if (fsPath == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error occurred while checking ancestry of peg path");
            SVNErrorManager.error(err);
        }
        return history != null && fsPath.equals(currentHistory.getPath());
    }

    public static FSNodeHistory getNodeHistory(FSRevisionRoot root, String path) throws SVNException {
        FSRevisionNode node = null;
        SVNNodeKind kind = null;
        try {
            node = root.openPath(path, true, false).getRevNode();
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                kind = SVNNodeKind.NONE;
            }
            throw svne;
        }
        kind = node.getType();
        if (kind == SVNNodeKind.NONE) {
            SVNErrorManager.error(FSErrors.errorNotFound(root, path));
        }
        return new FSNodeHistory(new SVNLocationEntry(root.getRevision(), path), false, new SVNLocationEntry(-1L, null));
    }

    private FSNodeHistory historyPrev(boolean crossCopies, FSFS owner) throws SVNException {
        String path = this.historyEntry.getPath();
        long revision = this.historyEntry.getRevision();
        boolean reported = this.isInteresting;
        if (this.searchResumeEntry != null && this.searchResumeEntry.getPath() != null && FSRepository.isValidRevision(this.searchResumeEntry.getRevision())) {
            reported = false;
            if (!crossCopies) {
                return null;
            }
            path = this.searchResumeEntry.getPath();
            revision = this.searchResumeEntry.getRevision();
        }
        FSRevisionRoot root = owner.createRevisionRoot(revision);
        FSParentPath parentPath = root.openPath(path, true, true);
        FSRevisionNode revNode = parentPath.getRevNode();
        SVNLocationEntry commitEntry = new SVNLocationEntry(revNode.getCreatedRevision(), revNode.getCreatedPath());
        FSNodeHistory prevHist = null;
        if (revision == commitEntry.getRevision()) {
            if (!reported) {
                prevHist = new FSNodeHistory(commitEntry, true, new SVNLocationEntry(-1L, null));
                return prevHist;
            }
            FSID predId = revNode.getPredecessorId();
            if (predId == null) {
                return prevHist;
            }
            revNode = owner.getRevisionNode(predId);
            commitEntry = new SVNLocationEntry(revNode.getCreatedRevision(), revNode.getCreatedPath());
        }
        SVNLocationEntry copyrootEntry = FSNodeHistory.findYoungestCopyroot(owner.getRepositoryRoot(), parentPath);
        SVNLocationEntry srcEntry = new SVNLocationEntry(-1L, null);
        long dstRev = -1L;
        if (copyrootEntry.getRevision() > commitEntry.getRevision()) {
            FSRevisionRoot copyrootRoot = owner.createRevisionRoot(copyrootEntry.getRevision());
            revNode = copyrootRoot.getRevisionNode(copyrootEntry.getPath());
            String copyDst = revNode.getCreatedPath();
            String reminder = null;
            reminder = path.equals(copyDst) ? "" : SVNPathUtil.pathIsChild(copyDst, path);
            if (reminder != null) {
                String copySrc = revNode.getCopyFromPath();
                srcEntry = new SVNLocationEntry(revNode.getCopyFromRevision(), SVNPathUtil.concatToAbs(copySrc, reminder));
                dstRev = copyrootEntry.getRevision();
            }
        }
        if (srcEntry.getPath() != null && FSRepository.isValidRevision(srcEntry.getRevision())) {
            boolean retry = false;
            if (dstRev == revision && reported) {
                retry = true;
            }
            return new FSNodeHistory(new SVNLocationEntry(dstRev, path), !retry, new SVNLocationEntry(srcEntry.getRevision(), srcEntry.getPath()));
        }
        return new FSNodeHistory(commitEntry, true, new SVNLocationEntry(-1L, null));
    }

    public FSNodeHistory fsHistoryPrev(boolean crossCopies, FSFS owner) throws SVNException {
        if ("/".equals(this.historyEntry.getPath())) {
            if (!this.isInteresting) {
                return new FSNodeHistory(new SVNLocationEntry(this.historyEntry.getRevision(), "/"), true, new SVNLocationEntry(-1L, null));
            }
            if (this.historyEntry.getRevision() > 0L) {
                return new FSNodeHistory(new SVNLocationEntry(this.historyEntry.getRevision() - 1L, "/"), true, new SVNLocationEntry(-1L, null));
            }
        } else {
            FSNodeHistory prevHist = this;
            do {
                if ((prevHist = prevHist.historyPrev(crossCopies, owner)) != null) continue;
                return null;
            } while (!prevHist.isInteresting);
            return prevHist;
        }
        return null;
    }
}

