/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNLookDateCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookLockCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(err, "jsvnlook: Repository argument required");
            System.exit(1);
        }
        if (this.getCommandLine().getPathCount() < 2) {
            SVNCommand.println(err, "jsvnlook: Missing path argument");
            System.exit(1);
        }
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        String path = SVNPathUtil.canonicalizeAbsPath((String)this.getCommandLine().getPathAt(1));
        SVNLookClient lookClient = this.getClientManager().getLookClient();
        SVNLock lock = lookClient.doGetLock(reposRoot, path);
        if (lock != null) {
            String creationTime = SVNLookDateCommand.formatDate(lock.getCreationDate());
            String expirationTime = lock.getExpirationDate() != null ? SVNLookDateCommand.formatDate(lock.getExpirationDate()) : "";
            int commentLines = 0;
            if (lock.getComment() != null) {
                commentLines = SVNLookLockCommand.getLinesCount(lock.getComment());
            }
            SVNCommand.println(out, "UUID Token: " + lock.getID());
            SVNCommand.println(out, "Owner: " + lock.getOwner());
            SVNCommand.println(out, "Created: " + creationTime);
            SVNCommand.println(out, "Expires: " + expirationTime);
            if (commentLines != 1) {
                SVNCommand.println(out, "Comment (" + commentLines + " lines):");
                SVNCommand.println(out, lock.getComment() != null ? lock.getComment() : "");
            } else {
                SVNCommand.println(out, "Comment (" + commentLines + " line):");
                SVNCommand.println(out, lock.getComment() != null ? lock.getComment() : "");
            }
        }
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }
}

