/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SVNCheckoutCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        String url = this.getCommandLine().getURL(0);
        String path = this.getCommandLine().getPathCount() > 0 ? this.getCommandLine().getPathAt(0) : new File(".", SVNEncodingUtil.uriDecode((String)SVNPathUtil.tail((String)url))).getAbsolutePath();
        SVNRevision revision = SVNCheckoutCommand.parseRevision(this.getCommandLine());
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, true));
        SVNUpdateClient updater = this.getClientManager().getUpdateClient();
        if (this.getCommandLine().getURLCount() == 1) {
            SVNRevision pegRevision = this.getCommandLine().getPegRevision(0);
            updater.doCheckout(SVNURL.parseURIEncoded((String)url), new File(path), pegRevision, revision, !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
        } else {
            for (int i = 0; i < this.getCommandLine().getURLCount(); ++i) {
                String curl = this.getCommandLine().getURL(i);
                File dstPath = new File(path, SVNEncodingUtil.uriDecode((String)SVNPathUtil.tail((String)curl)));
                SVNRevision pegRevision = this.getCommandLine().getPegRevision(i);
                updater.doCheckout(SVNURL.parseURIEncoded((String)url), dstPath, pegRevision, revision, !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
            }
        }
    }
}

