/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.ui.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.LogicalGem;
import com.aptana.rdt.ui.gems.GemContentProvider;
import com.aptana.rdt.ui.gems.GemLabelProvider;
import com.aptana.rdt.ui.gems.GemsMessages;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;
import org.rubypeople.rdt.ui.TableViewerSorter;

public class InstallGemDialog
extends Dialog {
    private Text nameText;
    private Combo versionCombo;
    private String name;
    private String version;
    private boolean filterByText = true;
    private TableViewer gemViewer;
    private GemContentProvider contentProvider = new GemContentProvider();
    private Combo sourceURLCombo;
    private String sourceURL = "http://gems.rubyforge.org";

    public InstallGemDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(GemsMessages.InstallGemDialog_dialog_title);
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        control.setLayout((Layout)layout);
        Label sourceLabel = new Label(control, 16384);
        sourceLabel.setText("Source URL");
        this.sourceURLCombo = new Combo(control, 4);
        GridData sourceTextData = new GridData();
        sourceTextData.widthHint = 300;
        this.sourceURLCombo.setLayoutData((Object)sourceTextData);
        this.updateSourceURLs();
        this.sourceURLCombo.setText(this.sourceURL);
        final Button sourceButton = new Button(control, 0);
        sourceButton.setText("Update");
        sourceButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                UIJob job = new UIJob("Loading gem listing..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        sourceButton.setEnabled(false);
                        InstallGemDialog.this.sourceURL = InstallGemDialog.this.sourceURLCombo.getText();
                        InstallGemDialog.this.gemViewer.setInput((Object)AptanaRDTPlugin.getDefault().getGemManager().getRemoteGems(InstallGemDialog.this.sourceURL, monitor));
                        InstallGemDialog.this.gemViewer.refresh();
                        InstallGemDialog.this.updateSourceURLs();
                        sourceButton.setEnabled(true);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        Label nameLabel = new Label(control, 16384);
        nameLabel.setText(GemsMessages.InstallGemDialog_name_label);
        this.nameText = new Text(control, 2048);
        GridData nameTextData = new GridData();
        nameTextData.widthHint = 150;
        nameTextData.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)nameTextData);
        final MyViewerFilter filter = new MyViewerFilter();
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InstallGemDialog.this.filterByText) {
                    InstallGemDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            filter.setText(InstallGemDialog.this.nameText.getText());
                            InstallGemDialog.this.gemViewer.refresh();
                        }
                    });
                }
                InstallGemDialog.this.filterByText = true;
            }
        });
        Label versionLabel = new Label(control, 16384);
        versionLabel.setText(GemsMessages.InstallGemDialog_version_label);
        this.versionCombo = new Combo(control, 4);
        GridData versionComboData = new GridData();
        versionComboData.widthHint = 100;
        versionComboData.horizontalSpan = 2;
        this.versionCombo.setLayoutData((Object)versionComboData);
        this.gemViewer = new TableViewer(parent, 65540);
        Table serverTable = this.gemViewer.getTable();
        serverTable.setHeaderVisible(true);
        serverTable.setLinesVisible(false);
        GridData data = new GridData(768);
        data.heightHint = 400;
        serverTable.setLayoutData((Object)data);
        TableColumn nameColumn = new TableColumn(serverTable, 16384);
        nameColumn.setText(GemsMessages.GemsView_NameColumn_label);
        nameColumn.setWidth(150);
        TableColumn versionColumn = new TableColumn(serverTable, 16384);
        versionColumn.setText(GemsMessages.GemsView_VersionColumn_label);
        versionColumn.setWidth(75);
        TableColumn descriptionColumn = new TableColumn(serverTable, 16384);
        descriptionColumn.setText(GemsMessages.GemsView_DescriptionColumn_label);
        descriptionColumn.setWidth(275);
        this.gemViewer.setLabelProvider((IBaseLabelProvider)new GemLabelProvider());
        this.gemViewer.setContentProvider((IContentProvider)this.contentProvider);
        TableViewerSorter.bind((TableViewer)this.gemViewer);
        this.gemViewer.setInput((Object)AptanaRDTPlugin.getDefault().getGemManager().getRemoteGems());
        this.gemViewer.addFilter((ViewerFilter)filter);
        this.gemViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structured = (IStructuredSelection)selection;
                    LogicalGem gem = (LogicalGem)structured.getFirstElement();
                    SortedSet versions = gem.getVersions();
                    InstallGemDialog.this.filterByText = false;
                    InstallGemDialog.this.nameText.setText(gem.getName());
                    InstallGemDialog.this.versionCombo.removeAll();
                    String lastVersion = null;
                    for (String version : versions) {
                        InstallGemDialog.this.versionCombo.add(version);
                        lastVersion = version;
                    }
                    InstallGemDialog.this.versionCombo.setText(lastVersion);
                }
            }
        });
        return control;
    }

    protected void updateSourceURLs() {
        this.sourceURLCombo.removeAll();
        Set urls = AptanaRDTPlugin.getDefault().getGemManager().getSourceURLs();
        for (String url : urls) {
            this.sourceURLCombo.add(url);
        }
    }

    public void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.name = this.nameText.getText();
            this.version = this.versionCombo.getText();
            this.okPressed();
        } else if (buttonId == 1) {
            this.cancelPressed();
        }
    }

    public Gem getGem() {
        return new Gem(this.name, this.version, "");
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    private static class MyViewerFilter
    extends ViewerFilter {
        private String value;

        private MyViewerFilter() {
        }

        public void setText(String value) {
            this.value = value == null ? null : value.toLowerCase();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.value == null || this.value.trim().length() == 0) {
                return true;
            }
            Gem gem = (Gem)element;
            return gem.getName().toLowerCase().startsWith(this.value);
        }
    }
}

