/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.ui.text.correction;

import com.aptana.rdt.internal.ui.text.correction.LocalCorrectionsSubProcessor;
import com.aptana.rdt.ui.AptanaRDTUIPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.jruby.ast.BlockNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.rewriter.FormatHelper;
import org.jruby.ast.visitor.rewriter.ReWriteVisitor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.formatter.EditableFormatHelper;
import org.rubypeople.rdt.core.formatter.Indents;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IProblemLocation;
import org.rubypeople.rdt.ui.text.ruby.IQuickFixProcessor;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickFixProcessor
implements IQuickFixProcessor {
    private static final String NEWLINE = "\n";

    public IRubyCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        ArrayList<IRubyCompletionProposal> resultingCollections = new ArrayList<IRubyCompletionProposal>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            Integer id = new Integer(curr.getProblemId());
            if (handledProblems.add(id)) {
                this.process(context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections.toArray(new IRubyCompletionProposal[resultingCollections.size()]);
    }

    public boolean hasCorrections(IRubyScript unit, int problemId) {
        switch (problemId) {
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: {
                return true;
            }
        }
        return false;
    }

    private void process(IInvocationContext context, IProblemLocation problem, Collection<IRubyCompletionProposal> proposals) throws CoreException {
        int id = problem.getProblemId();
        if (id == 0) {
            return;
        }
        switch (id) {
            case 128: {
                LocalCorrectionsSubProcessor.addReplacementProposal("initialize\n", "Rename to 'initialize'", problem, proposals);
                break;
            }
            case 129: {
                String constName = this.getProblemSource(context, problem);
                String fixed = Util.camelCaseToUnderscores((String)constName).toUpperCase();
                LocalCorrectionsSubProcessor.addReplacementProposal(fixed, "Convert to UPPERCASE_WITH_UNDERSCORES convention", problem, proposals);
                break;
            }
            case 134: {
                String local = this.getProblemSource(context, problem);
                String fixed = "self." + local;
                LocalCorrectionsSubProcessor.addReplacementProposal(fixed, "change assignment to " + fixed + " to use attribute", problem, proposals);
                break;
            }
            case 131: {
                String name = this.getProblemSource(context, problem);
                String fixed = Util.camelCaseToUnderscores((String)name).toLowerCase();
                LocalCorrectionsSubProcessor.addReplacementProposal(fixed, "Convert to lowercase_with_undercores convention", problem, proposals);
                break;
            }
            case 130: {
                int offset = this.getOffsetOfFirstLineInsideType(context, problem);
                String text = this.insertedMethodText(context, offset, "respond_to?", new String[]{"symbol", "include_private = false"});
                LocalCorrectionsSubProcessor.addReplacementProposal(offset, 0, text, "Add respond_to? method stub", proposals);
                break;
            }
            case 132: {
                int offset = this.getOffsetOfFirstLineInsideType(context, problem);
                String text = this.insertedMethodText(context, offset, "<=>", new String[]{"other"});
                LocalCorrectionsSubProcessor.addReplacementProposal(offset, 0, text, "Add <=> method stub", proposals);
                break;
            }
            case 133: {
                int offset = this.getOffsetOfFirstLineInsideType(context, problem);
                String text = this.insertedMethodText(context, offset, "each", new String[0]);
                LocalCorrectionsSubProcessor.addReplacementProposal(offset, 0, text, "Add each method stub", proposals);
            }
        }
    }

    private String insertedMethodText(IInvocationContext context, int offset, String methodName, String[] args) {
        IRubyScript script = context.getRubyScript();
        String src = "";
        try {
            src = script.getSource();
        }
        catch (RubyModelException e) {
            AptanaRDTUIPlugin.log(e);
        }
        DefnNode methodNode = NodeFactory.createMethodNode((String)methodName, (String[])args, null);
        BlockNode insert = NodeFactory.createBlockNode((boolean)true, (Node[])new Node[]{NodeFactory.createNewLineNode((Node)methodNode)});
        String text = ReWriteVisitor.createCodeFromNode((Node)insert, (String)src, (FormatHelper)this.getFormatHelper());
        StringBuffer buffer = new StringBuffer(text);
        int index = text.indexOf(NEWLINE, 1);
        buffer.insert(index + 1, "  # TODO Auto-generated method stub\n");
        String indent = this.findIndent(offset, script, src);
        buffer.insert(0, indent);
        buffer.append(NEWLINE);
        text = buffer.toString();
        text = text.replaceAll("\\n", NEWLINE + indent);
        return text;
    }

    private String findIndent(int offset, IRubyScript script, String src) {
        if (src == null || src.length() == 0) {
            return "";
        }
        int index = src.indexOf(NEWLINE, offset);
        if (index < 1 || index > src.length()) {
            return "";
        }
        String line = src.substring(0, index);
        index = line.lastIndexOf(NEWLINE);
        Map options = script.getRubyProject().getOptions(true);
        if (index == -1 || index + 1 >= line.length()) {
            return Indents.extractIndentString((String)line, (Map)options);
        }
        line = line.substring(index + 1);
        return Indents.extractIndentString((String)line, (Map)options);
    }

    private int getOffsetOfFirstLineInsideType(IInvocationContext context, IProblemLocation problem) {
        IRubyScript script = context.getRubyScript();
        int offset = -1;
        Node rootNode = ASTProvider.getASTProvider().getAST((IRubyElement)script, ASTProvider.WAIT_YES, null);
        Node typeNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner(rootNode, problem.getOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof ClassNode || node instanceof ModuleNode;
            }
        });
        if (typeNode instanceof ClassNode) {
            ClassNode classNode = (ClassNode)typeNode;
            offset = classNode.getBodyNode().getPosition().getStartOffset();
        } else if (typeNode instanceof ModuleNode) {
            ModuleNode classNode = (ModuleNode)typeNode;
            offset = classNode.getBodyNode().getPosition().getStartOffset();
        }
        return offset;
    }

    private String getProblemSource(IInvocationContext context, IProblemLocation problem) throws RubyModelException {
        IRubyScript script = context.getRubyScript();
        String src = script.getSource();
        return src.substring(problem.getOffset(), problem.getOffset() + problem.getLength());
    }

    protected FormatHelper getFormatHelper() {
        EditableFormatHelper helper = new EditableFormatHelper();
        helper.setAlwaysParanthesizeMethodCalls(true);
        helper.setAlwaysParanthesizeMethodDefs(true);
        return helper;
    }
}

