/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.resources.ui.ResourceStructureBridge;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.internal.WorkingSet;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.ExternalSourceFolderRoot;
import org.rubypeople.rdt.internal.ui.packageview.LoadPathContainer;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "ruby";

    public boolean acceptsObject(Object object) {
        if (object instanceof IResource) {
            Object adapter = ((IResource)object).getAdapter(IRubyElement.class);
            return adapter instanceof IRubyElement;
        }
        boolean accepts = object instanceof IRubyElement || object instanceof LoadPathContainer || object instanceof LoadPathContainer.RequiredProjectWrapper || object instanceof ISourceFolder || object instanceof WorkingSet;
        return accepts;
    }

    public boolean canBeLandmark(String handle) {
        IRubyElement element = (IRubyElement)this.getObjectForHandle(handle);
        return (element instanceof IMember || element instanceof IType) && element.exists();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean canFilter(Object object) {
        if (object instanceof LoadPathContainer.RequiredProjectWrapper) {
            return true;
        }
        if (object instanceof LoadPathContainer) {
            LoadPathContainer container = (LoadPathContainer)object;
            Object[] children = container.getChildren((Object)container);
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof ExternalSourceFolderRoot) {
                    ExternalSourceFolderRoot element = (ExternalSourceFolderRoot)children[i];
                    IInteractionElement node = ContextCorePlugin.getContextManager().getElement(element.getHandleIdentifier());
                    if (node != null && node.getInterest().isInteresting()) {
                        return false;
                    }
                }
                ++i;
            }
        } else if (object instanceof WorkingSet) {
            try {
                WorkingSet workingSet = (WorkingSet)object;
                IAdaptable[] elements = workingSet.getElements();
                int i = 0;
                while (i < elements.length) {
                    IAdaptable adaptable = elements[i];
                    IInteractionElement element = ContextCorePlugin.getContextManager().getElement(this.getHandleIdentifier(adaptable));
                    if (element.getInterest().isInteresting()) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public List<String> getChildHandles(String handle) {
        IRubyElement element;
        Object object = this.getObjectForHandle(handle);
        if (object instanceof IRubyElement && (element = (IRubyElement)object) instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                List resourceChildren;
                IRubyElement[] children = parent.getChildren();
                ArrayList<String> childHandles = new ArrayList<String>();
                int i = 0;
                while (i < children.length) {
                    String childHandle = this.getHandleIdentifier(children[i]);
                    if (childHandle != null) {
                        childHandles.add(childHandle);
                    }
                    ++i;
                }
                AbstractContextStructureBridge parentBridge = ContextCorePlugin.getDefault().getStructureBridge(this.parentContentType);
                if (parentBridge != null && parentBridge instanceof ResourceStructureBridge && element.getElementType() < 5 && !(resourceChildren = parentBridge.getChildHandles(handle)).isEmpty()) {
                    childHandles.addAll(resourceChildren);
                }
                return childHandles;
            }
            catch (RubyModelException rubyModelException) {
            }
            catch (Exception e) {
                StatusHandler.fail((Throwable)e, (String)"could not get child", (boolean)false);
            }
        }
        return Collections.emptyList();
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentType(String arg0) {
        return this.getContentType();
    }

    public String getHandleForOffsetInObject(Object resource, int offset) {
        IRubyScript rubyScript;
        ConcreteMarker marker;
        block10: {
            if (resource == null || !(resource instanceof ConcreteMarker)) {
                return null;
            }
            marker = (ConcreteMarker)resource;
            IResource res = marker.getResource();
            rubyScript = null;
            if (!(res instanceof IFile)) break block10;
            IFile file = (IFile)res;
            if (file.getFileExtension().equals("rb")) {
                rubyScript = RubyCore.createRubyScriptFrom((IFile)file);
                break block10;
            }
            return null;
        }
        try {
            if (rubyScript != null) {
                IRubyElement rubyElement = rubyScript.getElementAt(marker.getMarker().getAttribute("charStart", 0));
                if (rubyElement != null) {
                    if (rubyElement instanceof IImportDeclaration) {
                        rubyElement = rubyElement.getParent().getParent();
                    }
                    return rubyElement.getHandleIdentifier();
                }
                return null;
            }
            return null;
        }
        catch (RubyModelException ex) {
            if (!ex.isDoesNotExist()) {
                ExceptionHandler.handle((CoreException)((Object)ex), (String)"error", (String)"could not find ruby element");
            }
            return null;
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)("Could not find element for: " + marker), (boolean)false);
            return null;
        }
    }

    public String getHandleIdentifier(Object object) {
        Object adapter;
        if (object instanceof IRubyElement) {
            return ((IRubyElement)object).getHandleIdentifier();
        }
        if (object instanceof IAdaptable && (adapter = ((IAdaptable)object).getAdapter(IRubyElement.class)) instanceof IRubyElement) {
            return ((IRubyElement)adapter).getHandleIdentifier();
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof IRubyElement) {
            return ((IRubyElement)object).getElementName();
        }
        return "";
    }

    public Object getObjectForHandle(String handle) {
        try {
            return RubyCore.create((String)handle);
        }
        catch (Throwable throwable) {
            StatusHandler.log((String)("Could not create ruby element for handle: " + handle), (Object)((Object)this));
            return null;
        }
    }

    public String getParentHandle(String handle) {
        IRubyElement javaElement = (IRubyElement)this.getObjectForHandle(handle);
        if (javaElement != null && javaElement.getParent() != null) {
            return this.getHandleIdentifier(javaElement.getParent());
        }
        return null;
    }

    public Object getAdaptedParent(Object object) {
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            return RubyCore.create((IResource)file.getParent());
        }
        return super.getAdaptedParent(object);
    }

    public boolean isDocument(String handle) {
        IRubyElement element = (IRubyElement)this.getObjectForHandle(handle);
        return element instanceof IRubyScript;
    }

    public boolean containsProblem(IInteractionElement node) {
        try {
            IRubyElement element = (IRubyElement)this.getObjectForHandle(node.getHandleIdentifier());
            switch (element.getElementType()) {
                case 1: 
                case 2: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 2, null);
                }
                case 3: 
                case 4: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                }
                case 5: 
                case 6: 
                case 8: 
                case 12: 
                case 15: 
                case 16: {
                    IRubyScript cu = (IRubyScript)element.getAncestor(4);
                    if (cu != null) {
                        return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                    }
                    break;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean getErrorTicksFromMarkers(IResource res, int depth, ISourceReference sourceElement) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return false;
        }
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            int i = 0;
            while (i < markers.length) {
                int priority;
                IMarker curr = markers[i];
                if (sourceElement == null && (priority = curr.getAttribute("severity", -1)) == 2) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

