/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.AbstractUserInteractionMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.rubypeople.rdt.core.IImportContainer;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;

public class RubyEditingMonitor
extends AbstractUserInteractionMonitor {
    protected IRubyElement lastSelectedElement = null;
    protected IRubyElement lastResolvedElement = null;
    protected RubyEditor currentEditor;
    protected StructuredSelection currentSelection = null;

    public void handleWorkbenchPartSelection(IWorkbenchPart part, ISelection selection, boolean contributeToContext) {
        try {
            IRubyElement selectedElement = null;
            if (selection instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                if (structuredSelection.equals((Object)this.currentSelection)) {
                    return;
                }
                this.currentSelection = structuredSelection;
                Object selectedObject = structuredSelection.getFirstElement();
                if (selectedObject instanceof IRubyElement) {
                    IRubyElement checkedElement = this.checkIfAcceptedAndPromoteIfNecessary((IRubyElement)selectedObject);
                    if (checkedElement == null) {
                        return;
                    }
                    selectedElement = checkedElement;
                }
                if (selectedElement != null) {
                    super.handleElementSelection(part, (Object)selectedElement, contributeToContext);
                }
            } else if (selection instanceof TextSelection && part instanceof RubyEditor) {
                IRubyElement checkedElement;
                this.currentEditor = (RubyEditor)part;
                TextSelection textSelection = (TextSelection)selection;
                selectedElement = SelectionConverter.resolveEnclosingElement((RubyEditor)this.currentEditor, (ITextSelection)textSelection);
                IRubyElement[] resolved = SelectionConverter.codeResolve((RubyEditor)this.currentEditor);
                if (resolved != null && resolved.length == 1 && resolved[0] != null && !resolved[0].equals(selectedElement)) {
                    this.lastResolvedElement = resolved[0];
                }
                boolean selectionResolved = false;
                if (selectedElement instanceof IMethod && this.lastSelectedElement instanceof IMethod) {
                    if (this.lastResolvedElement != null && this.lastSelectedElement != null && this.lastResolvedElement.equals(selectedElement) && !this.lastSelectedElement.equals(this.lastResolvedElement)) {
                        super.handleNavigation(part, (Object)selectedElement, "org.eclipse.mylyn.ruby.relation.references", contributeToContext);
                        selectionResolved = true;
                    } else if (this.lastSelectedElement != null && this.lastSelectedElement.equals(this.lastResolvedElement) && !this.lastSelectedElement.equals(selectedElement)) {
                        super.handleNavigation(part, (Object)selectedElement, "org.eclipse.mylyn.ruby.relation.references", contributeToContext);
                        selectionResolved = true;
                    }
                }
                if (selectedElement != null) {
                    if (!selectionResolved && selectedElement.equals(this.lastSelectedElement)) {
                        super.handleElementEdit(part, (Object)selectedElement, contributeToContext);
                    } else if (!selectedElement.equals(this.lastSelectedElement)) {
                        super.handleElementSelection(part, (Object)selectedElement, contributeToContext);
                    }
                }
                if ((checkedElement = this.checkIfAcceptedAndPromoteIfNecessary(selectedElement)) == null) {
                    return;
                }
                selectedElement = checkedElement;
            }
            if (selectedElement != null) {
                this.lastSelectedElement = selectedElement;
            }
        }
        catch (RubyModelException rubyModelException) {
        }
        catch (Throwable t) {
            StatusHandler.log((Throwable)t, (String)"Failed to update model based on selection.");
        }
    }

    protected IRubyElement checkIfAcceptedAndPromoteIfNecessary(IRubyElement element) {
        if (element instanceof IImportContainer) {
            return element.getParent();
        }
        if (element instanceof IImportDeclaration) {
            return element.getParent().getParent();
        }
        return element;
    }
}

