/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui;

import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyScript;

public class InterestUpdateDeltaListener
implements IElementChangedListener {
    private static boolean asyncExecMode = true;

    public void elementChanged(ElementChangedEvent event) {
        IRubyElementDelta delta = event.getDelta();
        this.handleDelta(delta.getAffectedChildren());
    }

    private void handleDelta(IRubyElementDelta[] delta) {
        try {
            IInteractionElement element;
            IRubyElement added = null;
            IRubyElement removed = null;
            int i = 0;
            while (i < delta.length) {
                IRubyElementDelta child = delta[i];
                if (child.getElement() instanceof IRubyScript && ((IRubyScript)child.getElement()).getOwner() != null) {
                    return;
                }
                if (child.getKind() == 1) {
                    if (added == null) {
                        added = child.getElement();
                    }
                } else if (child.getKind() == 2 && removed == null) {
                    removed = child.getElement();
                }
                this.handleDelta(child.getAffectedChildren());
                ++i;
            }
            if (added != null && removed != null) {
                IInteractionElement element2 = ContextCorePlugin.getContextManager().getElement(removed.getHandleIdentifier());
                if (element2 != null) {
                    this.resetHandle(element2, added.getHandleIdentifier());
                }
            } else if (removed != null && (element = ContextCorePlugin.getContextManager().getElement(removed.getHandleIdentifier())) != null) {
                this.delete(element);
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"delta update failed", (boolean)false);
        }
    }

    private void resetHandle(final IInteractionElement element, final String newHandle) {
        if (!asyncExecMode) {
            ContextCorePlugin.getContextManager().updateHandle(element, newHandle);
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                workbench.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ContextCorePlugin.getContextManager().updateHandle(element, newHandle);
                    }
                });
            }
        }
    }

    private void delete(final IInteractionElement element) {
        if (!asyncExecMode) {
            ContextCorePlugin.getContextManager().delete(element);
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                workbench.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ContextCorePlugin.getContextManager().delete(element);
                    }
                });
            }
        }
    }

    public static void setAsyncExecMode(boolean asyncExecMode) {
        InterestUpdateDeltaListener.asyncExecMode = asyncExecMode;
    }
}

