/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.mylyn.internal.ruby.ui;

import com.aptana.rdt.mylyn.internal.ruby.ui.RubyStructureBridge;
import com.aptana.rdt.mylyn.internal.ruby.ui.RubyUiBridgePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.viewsupport.IProblemChangedListener;

public class InterestInducingProblemListener
implements IProblemChangedListener,
IPropertyChangeListener {
    public static final String PREDICTED_INTEREST_ERRORS = "com.aptana.rdt.mylyn.ruby.ui.interest.prediction.errors";
    private RubyStructureBridge javaStructureBridge = new RubyStructureBridge();

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        try {
            if (!ContextCorePlugin.getContextManager().isContextActive()) {
                return;
            }
            int i = 0;
            while (i < changedResources.length) {
                IRubyElement javaElement;
                IResource resource = changedResources[i];
                if (resource instanceof IFile && (javaElement = (IRubyElement)resource.getAdapter(IRubyElement.class)) != null) {
                    IInteractionElement element = ContextCorePlugin.getContextManager().getElement(javaElement.getHandleIdentifier());
                    if (!this.javaStructureBridge.containsProblem(element)) {
                        ContextCorePlugin.getContextManager().removeErrorPredictedInterest(element.getHandleIdentifier(), "ruby", true);
                    } else {
                        ContextCorePlugin.getContextManager().addErrorPredictedInterest(element.getHandleIdentifier(), "ruby", true);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            StatusHandler.log((Throwable)e, (String)"could not update on marker change");
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (PREDICTED_INTEREST_ERRORS.equals(event.getProperty())) {
            if (RubyUiBridgePlugin.getDefault().getPreferenceStore().getBoolean(PREDICTED_INTEREST_ERRORS)) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }

    public void enable() {
        RubyPlugin.getDefault().getProblemMarkerManager().addListener((IProblemChangedListener)this);
    }

    public void disable() {
        RubyPlugin.getDefault().getProblemMarkerManager().removeListener((IProblemChangedListener)this);
    }
}

