/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.Node;
import org.jruby.ast.SuperNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class SubclassCallsSuper
extends RubyLintVisitor {
    private boolean inConstructor;
    private boolean calledSuper;
    private boolean isSubClass;

    public SubclassCallsSuper(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.subclassDoesntCallSuper";
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        Node superNode = iVisited.getSuperNode();
        if (superNode != null) {
            this.isSubClass = true;
        }
        return super.visitClassNode(iVisited);
    }

    public void exitClassNode(ClassNode iVisited) {
        this.isSubClass = false;
        super.exitClassNode(iVisited);
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        if (!this.isSubClass) {
            return null;
        }
        if (!iVisited.getName().equals("initialize")) {
            return null;
        }
        this.inConstructor = true;
        this.calledSuper = false;
        return super.visitDefnNode(iVisited);
    }

    public Instruction visitSuperNode(SuperNode iVisited) {
        if (this.inConstructor) {
            this.calledSuper = true;
        }
        return super.visitSuperNode(iVisited);
    }

    public Instruction visitZSuperNode(ZSuperNode iVisited) {
        if (this.inConstructor) {
            this.calledSuper = true;
        }
        return super.visitZSuperNode(iVisited);
    }

    public void exitDefnNode(DefnNode iVisited) {
        if (!this.isSubClass) {
            return;
        }
        if (!iVisited.getName().equals("initialize")) {
            return;
        }
        if (!this.calledSuper) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Subclass does not call super in constructor");
        }
        this.inConstructor = false;
        super.exitDefnNode(iVisited);
    }
}

