/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.internal.parser.warnings.AccidentalBooleanAssignmentVisitor;
import com.aptana.rdt.internal.parser.warnings.AndOrUsedOnRighthandAssignment;
import com.aptana.rdt.internal.parser.warnings.ComparableInclusionVisitor;
import com.aptana.rdt.internal.parser.warnings.ConstantNamingConvention;
import com.aptana.rdt.internal.parser.warnings.DynamicVariableAliasesLocal;
import com.aptana.rdt.internal.parser.warnings.EnumerableInclusionVisitor;
import com.aptana.rdt.internal.parser.warnings.LocalAndMethodNamingConvention;
import com.aptana.rdt.internal.parser.warnings.LocalVariablePossibleAttributeAccess;
import com.aptana.rdt.internal.parser.warnings.LocalsMaskingMethodsVisitor;
import com.aptana.rdt.internal.parser.warnings.MethodMissingWithoutRespondTo;
import com.aptana.rdt.internal.parser.warnings.MisspelledConstructorVisitor;
import com.aptana.rdt.internal.parser.warnings.SimilarVariableNameVisitor;
import com.aptana.rdt.internal.parser.warnings.SubclassCallsSuper;
import com.aptana.rdt.internal.parser.warnings.TooManyArgumentsVisitor;
import com.aptana.rdt.internal.parser.warnings.TooManyBranchesVisitor;
import com.aptana.rdt.internal.parser.warnings.TooManyLinesVisitor;
import com.aptana.rdt.internal.parser.warnings.TooManyLocalsVisitor;
import com.aptana.rdt.internal.parser.warnings.TooManyReturnsVisitor;
import com.aptana.rdt.internal.parser.warnings.UnecessaryElseVisitor;
import com.aptana.rdt.internal.parser.warnings.UnusedLocalVariable;
import com.aptana.rdt.internal.parser.warnings.UnusedParameterVisitor;
import com.aptana.rdt.internal.parser.warnings.UnusedPrivateMethodVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.RootNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.compiler.BuildContext;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.core.compiler.CompilationParticipant;
import org.rubypeople.rdt.core.compiler.ReconcileContext;
import org.rubypeople.rdt.core.parser.warnings.DelegatingVisitor;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyRedLint
extends CompilationParticipant {
    public void reconcile(ReconcileContext context) {
        try {
            String contents = context.getWorkingCopy().getSource();
            DelegatingVisitor visitor = new DelegatingVisitor(this.createLintVisitors(contents));
            RootNode node = context.getAST();
            if (node == null) {
                return;
            }
            node.accept((NodeVisitor)visitor);
            List problems = visitor.getProblems();
            CategorizedProblem[] oldProblems = context.getProblems("org.rubypeople.rdt.core.problem");
            if (oldProblems == null || oldProblems.length == 0) {
                context.putProblems("org.rubypeople.rdt.core.problem", problems.toArray(new CategorizedProblem[problems.size()]));
            } else {
                CategorizedProblem[] combined = new CategorizedProblem[problems.size() + oldProblems.length];
                int i = 0;
                while (i < oldProblems.length) {
                    combined[i] = oldProblems[i];
                    ++i;
                }
                int j = oldProblems.length;
                for (CategorizedProblem problem : problems) {
                    combined[j++] = problem;
                }
                context.putProblems("org.rubypeople.rdt.core.problem", combined);
            }
        }
        catch (RubyModelException e) {
            AptanaRDTPlugin.log(e);
        }
    }

    private List<CategorizedProblem> parse(String contents, RootNode ast) {
        if (ast == null) {
            RubyParser parser = new RubyParser();
            ast = (RootNode)parser.parse(contents);
        }
        DelegatingVisitor visitor = new DelegatingVisitor(this.createLintVisitors(contents));
        ast.accept((NodeVisitor)visitor);
        return visitor.getProblems();
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        super.buildStarting(files, isBatch);
        int i = 0;
        while (i < files.length) {
            BuildContext context = files[i];
            String contents = new String(context.getContents());
            List<CategorizedProblem> problems = this.parse(contents, null);
            context.recordNewProblems(problems.toArray(new CategorizedProblem[problems.size()]));
            ++i;
        }
    }

    public boolean isActive(IRubyProject project) {
        return true;
    }

    private List<RubyLintVisitor> createLintVisitors(String contents) {
        ArrayList<RubyLintVisitor> visitors = new ArrayList<RubyLintVisitor>();
        visitors.add(new AccidentalBooleanAssignmentVisitor(contents));
        visitors.add(new UnusedPrivateMethodVisitor(contents));
        visitors.add(new MisspelledConstructorVisitor(contents));
        visitors.add(new LocalsMaskingMethodsVisitor(contents));
        visitors.add(new UnusedParameterVisitor(contents));
        visitors.add(new UnecessaryElseVisitor(contents));
        visitors.add(new TooManyLocalsVisitor(contents));
        visitors.add(new TooManyLinesVisitor(contents));
        visitors.add(new TooManyBranchesVisitor(contents));
        visitors.add(new TooManyArgumentsVisitor(contents));
        visitors.add(new TooManyReturnsVisitor(contents));
        visitors.add(new SimilarVariableNameVisitor(contents));
        visitors.add(new SubclassCallsSuper(contents));
        visitors.add(new ComparableInclusionVisitor(contents));
        visitors.add(new EnumerableInclusionVisitor(contents));
        visitors.add(new AndOrUsedOnRighthandAssignment(contents));
        visitors.add(new ConstantNamingConvention(contents));
        visitors.add(new MethodMissingWithoutRespondTo(contents));
        visitors.add(new DynamicVariableAliasesLocal(contents));
        visitors.add(new LocalVariablePossibleAttributeAccess(contents));
        visitors.add(new LocalAndMethodNamingConvention(contents));
        visitors.add(new UnusedLocalVariable(contents));
        ArrayList<RubyLintVisitor> filtered = new ArrayList<RubyLintVisitor>();
        for (RubyLintVisitor visitor : visitors) {
            if (visitor.isIgnored()) continue;
            filtered.add(visitor);
        }
        return filtered;
    }
}

