/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class LocalsMaskingMethodsVisitor
extends RubyLintVisitor {
    private ArrayList<LocalAsgnNode> locals = new ArrayList();
    private HashSet<String> methods = new HashSet();

    public LocalsMaskingMethodsVisitor(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.localVariableMasksMethod";
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        this.methods.clear();
        this.locals.clear();
        return null;
    }

    public void exitClassNode(ClassNode iVisited) {
        this.findMaskingLocals();
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.methods.add(iVisited.getName());
        return null;
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.locals.add(iVisited);
        return null;
    }

    private void findMaskingLocals() {
        for (LocalAsgnNode local : this.locals) {
            if (!this.methods.contains(local.getName())) continue;
            this.createProblem(local.getPosition(), "Local variable hides method");
        }
    }
}

