/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.ClassNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

public class LocalVariablePossibleAttributeAccess
extends RubyLintVisitor {
    private List<LocalAsgnNode> locals = new ArrayList<LocalAsgnNode>();
    private List<String> attributes = new ArrayList<String>();

    public LocalVariablePossibleAttributeAccess(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.localVariablePossibleAttributeAccess";
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        this.locals.clear();
        this.attributes.clear();
        return super.visitClassNode(iVisited);
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.locals.add(iVisited);
        return super.visitLocalAsgnNode(iVisited);
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        String name = iVisited.getName();
        if (name.equals("attr_accessor") || name.equals("attr_writer") || name.equals("attr")) {
            List args = ASTUtil.getArgumentsFromFunctionCall((IArgumentNode)iVisited);
            if (name.equals("attr")) {
                if (args.size() < 2) {
                    return super.visitFCallNode(iVisited);
                }
                if (!((String)args.get(1)).equals("true")) {
                    return super.visitFCallNode(iVisited);
                }
                this.attributes.add((String)args.get(0));
                return super.visitFCallNode(iVisited);
            }
            this.attributes.addAll(args);
        }
        return super.visitFCallNode(iVisited);
    }

    public void exitClassNode(ClassNode iVisited) {
        for (LocalAsgnNode local : this.locals) {
            if (!this.attributes.contains(local.getName())) continue;
            this.createProblem(local.getPosition(), "Local variable assignment might be possible attribute access attempt?");
        }
        super.exitClassNode(iVisited);
    }

    protected int getProblemID() {
        return 134;
    }
}

