/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class EnumerableInclusionVisitor
extends RubyLintVisitor {
    private static final String INCLUDE = "include";
    private static final String ENUMERABLE_METHOD = "each";
    private static final String ENUMERABLE = "Enumerable";
    private boolean includedEnumerable = false;
    private boolean definedEnumerableMethod;
    private ISourcePosition pos;

    public EnumerableInclusionVisitor(String code) {
        super(AptanaRDTPlugin.getDefault().getOptions(), code);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.enumerableMissingMethod";
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        if (this.includedEnumerable) {
            return null;
        }
        String callName = iVisited.getName();
        if (!callName.equals(INCLUDE)) {
            return null;
        }
        Node args = iVisited.getArgsNode();
        if (args instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)args;
            for (Object arg : array.childNodes()) {
                ConstNode constNode;
                if (!(arg instanceof ConstNode) || !(constNode = (ConstNode)arg).getName().equals(ENUMERABLE)) continue;
                this.pos = constNode.getPosition();
                this.includedEnumerable = true;
                return null;
            }
        }
        return null;
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        String methodName = iVisited.getName();
        if (methodName.equals(ENUMERABLE_METHOD)) {
            this.definedEnumerableMethod = true;
        }
        return super.visitDefnNode(iVisited);
    }

    public void exitClassNode(ClassNode iVisited) {
        if (this.includedEnumerable && !this.definedEnumerableMethod) {
            this.createProblem(this.pos, "Included Enumerable but did not define an each method");
        }
        this.includedEnumerable = false;
        this.pos = null;
        this.definedEnumerableMethod = false;
    }

    protected int getProblemID() {
        return 133;
    }
}

