/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.List;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class DynamicVariableAliasesLocal
extends RubyLintVisitor {
    public DynamicVariableAliasesLocal(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.dynamicVariableAliasesLocal";
    }

    public Instruction visitIterNode(IterNode iVisited) {
        this.checkNode(iVisited.getVarNode());
        return super.visitIterNode(iVisited);
    }

    private void checkNode(Node varNode) {
        if (varNode == null) {
            return;
        }
        if (varNode instanceof ListNode) {
            this.checkListNode((ListNode)varNode);
        } else if (varNode instanceof MultipleAsgnNode) {
            MultipleAsgnNode multi = (MultipleAsgnNode)varNode;
            this.checkList(multi.childNodes());
        } else if (varNode instanceof LocalAsgnNode) {
            this.createProblem(varNode.getPosition(), "Dynamic variable aliases local");
        }
    }

    private void checkListNode(ListNode node) {
        this.checkList(node.childNodes());
    }

    private void checkList(List list) {
        for (Object child : list) {
            Node childNode = (Node)child;
            this.checkNode(childNode);
        }
    }
}

