/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.launching;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.IGemManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.rubypeople.rdt.core.LoadpathVariableInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.RubyRuntime;

public class GemLoadpathVariablesInitializer
extends LoadpathVariableInitializer {
    private IProgressMonitor fMonitor;

    public void initialize(String variable) {
        IVMInstall vmInstall = RubyRuntime.getDefaultVMInstall();
        if (vmInstall != null) {
            IPath newPath = null;
            IGemManager gemManager = AptanaRDTPlugin.getDefault().getGemManager();
            IPath gemPath = gemManager.getGemInstallPath();
            if (gemPath != null) {
                if (variable.equals("GEM_LIB")) {
                    newPath = gemPath.append("gems");
                }
                if (newPath == null) {
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceDescription wsDescription = workspace.getDescription();
                boolean wasAutobuild = wsDescription.isAutoBuilding();
                try {
                    try {
                        this.setAutobuild(workspace, false);
                        this.setRubyVMVariable(newPath, variable);
                    }
                    catch (CoreException ce) {
                        LaunchingPlugin.log((Throwable)ce);
                        try {
                            this.setAutobuild(workspace, wasAutobuild);
                        }
                        catch (CoreException ce2) {
                            LaunchingPlugin.log((Throwable)ce2);
                        }
                        return;
                    }
                }
                finally {
                    try {
                        this.setAutobuild(workspace, wasAutobuild);
                    }
                    catch (CoreException ce) {
                        LaunchingPlugin.log((Throwable)ce);
                    }
                }
            }
        }
    }

    private void setRubyVMVariable(IPath newPath, String var) throws CoreException {
        RubyCore.setLoadpathVariable((String)var, (IPath)newPath, (IProgressMonitor)this.getMonitor());
    }

    private boolean setAutobuild(IWorkspace ws, boolean newState) throws CoreException {
        IWorkspaceDescription wsDescription = ws.getDescription();
        boolean oldState = wsDescription.isAutoBuilding();
        if (oldState != newState) {
            wsDescription.setAutoBuilding(newState);
            ws.setDescription(wsDescription);
        }
        return oldState;
    }

    protected IProgressMonitor getMonitor() {
        if (this.fMonitor == null) {
            return new NullProgressMonitor();
        }
        return this.fMonitor;
    }
}

