/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core.gems;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemVersion
implements Comparable<GemVersion> {
    private String string;
    private List<String> versions;

    public GemVersion(String version) {
        this.string = version;
        StringTokenizer tokenizer = new StringTokenizer(this.string, ".");
        this.versions = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            this.versions.add(tokenizer.nextToken());
        }
    }

    @Override
    public int compareTo(GemVersion o) {
        int diff = this.getMajor() - o.getMajor();
        if (diff != 0) {
            return diff;
        }
        diff = this.getMinor() - o.getMinor();
        if (diff != 0) {
            return diff;
        }
        return this.getBugfix() - o.getBugfix();
    }

    public int getMajor() {
        if (this.versions.isEmpty()) {
            return 0;
        }
        String major = this.versions.get(0);
        return Integer.parseInt(major);
    }

    public int getMinor() {
        if (this.versions.size() < 2) {
            return 0;
        }
        String minor = this.versions.get(1);
        return Integer.parseInt(minor);
    }

    public int getBugfix() {
        if (this.versions.size() < 3) {
            return 0;
        }
        String minor = this.versions.get(2);
        return Integer.parseInt(minor);
    }

    public String toString() {
        return this.string;
    }
}

