/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.GemListener;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.core.gems.LogicalGem;
import com.aptana.rdt.internal.core.gems.GemManagerContentHandler;
import com.aptana.rdt.internal.core.gems.GemParser;
import com.aptana.rdt.internal.core.gems.GemVersion;
import com.aptana.rdt.internal.core.gems.GemsMessages;
import com.aptana.rdt.internal.core.gems.SourceURLContentHandler;
import com.aptana.rdt.internal.core.gems.XMLWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.DataFormatException;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallChangedListener;
import org.rubypeople.rdt.launching.PropertyChangeEvent;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemManager
implements IGemManager {
    private static final String SOURCE_SWITCH = "--source";
    private static final String CLEANUP_COMMAND = "cleanup";
    private static final String INCLUDE_DEPENDENCIES_SWITCH = "-y";
    private static final String LOCAL_SWITCH = "-l";
    private static final String LIST_COMMAND = "list";
    private static final String INSTALL_COMMAND = "install";
    private static final String VERSION_SWITCH = "-v";
    private static final String UNINSTALL_COMMAND = "uninstall";
    private static final String UPDATE_COMMAND = "update";
    private static final String EXECUTABLE = "ruby";
    private static final String REMOTE_GEMS_CACHE_FILE = "remote_gems.xml";
    private static final String LOCAL_GEMS_CACHE_FILE = "local_gems.xml";
    private static final String SOURCE_URLS_CACHE_FILE = "source_urls.xml";
    private static final String GEM_INDEX_FILE = "yaml.Z";
    private static final String DEFAULT_GEM_INDEX_URL = "http://gems.rubyforge.org/yaml.Z";
    private static final String RAILS_GEM_HOST = "http://gems.rubyonrails.org";
    private static GemManager fgInstance;
    private Set<Gem> gems;
    private Set<Gem> remoteGems;
    private Set<GemListener> listeners;
    private Set<String> urls = new HashSet<String>();
    private List<IPath> fGemInstallPaths;
    protected boolean isInitialized;

    GemManager() {
        this.gems = new HashSet<Gem>();
        this.remoteGems = new HashSet<Gem>();
        this.listeners = new HashSet<GemListener>();
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set<Gem> loadLocalCache(File file) {
        FileReader fileReader;
        block14: {
            Set<Gem> set;
            fileReader = null;
            try {
                fileReader = new FileReader(file);
                XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                GemManagerContentHandler handler = new GemManagerContentHandler();
                reader.setContentHandler(handler);
                reader.parse(new InputSource(fileReader));
                set = handler.getGems();
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    break block14;
                    catch (SAXException e) {
                        AptanaRDTPlugin.log(e);
                        break block14;
                    }
                    catch (ParserConfigurationException e) {
                        AptanaRDTPlugin.log(e);
                        break block14;
                    }
                    catch (FactoryConfigurationError e) {
                        AptanaRDTPlugin.log(e);
                        break block14;
                    }
                    catch (IOException e) {
                        AptanaRDTPlugin.log(e);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fileReader == null) throw throwable;
                        fileReader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (fileReader == null) return set;
                fileReader.close();
                return set;
            }
            catch (IOException iOException) {}
            return set;
        }
        try {
            if (fileReader == null) return new HashSet<Gem>();
            fileReader.close();
            return new HashSet<Gem>();
        }
        catch (IOException iOException) {}
        return new HashSet<Gem>();
    }

    protected void storeGemCache(Set<Gem> gems, File file) {
        PrintWriter out = null;
        try {
            try {
                out = new XMLWriter(new FileOutputStream(file));
                this.writeXML(gems, (XMLWriter)out);
            }
            catch (FileNotFoundException e) {
                AptanaRDTPlugin.log(e);
            }
            catch (IOException e) {
                AptanaRDTPlugin.log(e);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected File getConfigFile(String fileName) {
        return AptanaRDTPlugin.getDefault().getStateLocation().append(fileName).toFile();
    }

    private void writeXML(Set<Gem> gems, XMLWriter out) {
        out.startTag("gems", null);
        for (Gem gem : gems) {
            out.startTag("gem", null);
            out.printSimpleTag("name", gem.getName());
            out.printSimpleTag("version", gem.getVersion());
            out.printSimpleTag("description", gem.getDescription());
            out.printSimpleTag("platform", gem.getPlatform());
            out.endTag("gem");
        }
        out.endTag("gems");
        out.flush();
    }

    private Set<Gem> loadRemoteGems(String gemIndexUrl, IProgressMonitor monitor) {
        try {
            ArrayList<String> lines = new ArrayList();
            try {
                monitor.subTask("Retrieving remote gem index");
                lines = this.getContents(gemIndexUrl, monitor);
            }
            catch (DataFormatException e) {
                AptanaRDTPlugin.log(e);
            }
            monitor.worked(70);
            monitor.subTask("Parsing remote gem index");
            return this.convertToGems(lines);
        }
        catch (MalformedURLException e) {
            AptanaRDTPlugin.log(e);
        }
        catch (IOException e) {
            AptanaRDTPlugin.log(e);
        }
        return new HashSet<Gem>();
    }

    private Set<Gem> convertToGems(List<String> lines) {
        HashSet<Gem> gems = new HashSet<Gem>();
        String name = null;
        String version = null;
        String description = null;
        String platform = null;
        boolean nextIsRealVersion = false;
        for (String line : lines) {
            if (nextIsRealVersion && line.trim().startsWith("version: ")) {
                version = line.trim().substring(9);
                if (version.charAt(0) == '\"') {
                    version = version.substring(1);
                }
                if (version.charAt(version.length() - 1) == '\"') {
                    version = version.substring(0, version.length() - 1);
                }
                nextIsRealVersion = false;
            } else if (line.trim().equals("version: !ruby/object:Gem::Version")) {
                nextIsRealVersion = true;
            }
            if (line.trim().startsWith("name:")) {
                name = line.trim().substring(6);
            }
            if (line.trim().startsWith("platform:")) {
                platform = line.trim().length() == 9 ? EXECUTABLE : line.trim().substring(10);
            }
            if (line.trim().startsWith("summary:")) {
                description = line.trim().substring(9);
            }
            if (description == null || name == null || version == null || platform == null) continue;
            gems.add(new Gem(name, version, description, platform));
            description = null;
            version = null;
            name = null;
            platform = null;
        }
        return gems;
    }

    private List<String> getContents(String gemIndexUrl, IProgressMonitor monitor) throws MalformedURLException, IOException, DataFormatException {
        String outputString = new String(this.getZippedGemIndex(gemIndexUrl, monitor));
        String[] lineArray = outputString.split("\n");
        return Arrays.asList(lineArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getZippedGemIndex(String gemIndexUrl, IProgressMonitor monitor) {
        content = null;
        input = new byte[1024];
        index = 0;
        try {
            url = new URL(gemIndexUrl);
            con = url.openConnection();
            content = new InflaterInputStream((InputStream)con.getContent());
lbl8:
            // 2 sources

            while (true) {
                if (!monitor.isCanceled()) ** GOTO lbl-1000
                var12_12 = new byte[]{};
                ** GOTO lbl28
                break;
            }
        }
        catch (Exception e) {
            AptanaRDTPlugin.log(e);
            var12_13 = new byte[]{};
            try {
                if (content == null) return var12_13;
                content.close();
                return var12_13;
            }
            catch (IOException v0) {}
            return var12_13;
            catch (Throwable var11_14) {
                try {
                    if (content == null) throw var11_14;
                    content.close();
                    throw var11_14;
                }
                catch (IOException v1) {}
                throw var11_14;
            }
lbl28:
            // 1 sources

            try {
                if (content == null) return var12_12;
                content.close();
                return var12_12;
            }
            catch (IOException v2) {}
            return var12_12;
lbl-1000:
            // 1 sources

            {
                tmp = new byte[4096];
                length = content.read(tmp);
                if (length != -1) ** GOTO lbl41
lbl-1000:
                // 1 sources

                {
                    newInput = new byte[input.length * 2];
                    System.arraycopy(input, 0, newInput, 0, input.length);
                    input = newInput;
lbl41:
                    // 2 sources

                    ** while (index + length > input.length)
                }
lbl42:
                // 1 sources

                System.arraycopy(tmp, 0, input, index, length);
                index += length;
                ** continue;
            }
        }
        try {
            if (content != null) {
                content.close();
            }
        }
        catch (IOException v3) {}
        newInput = new byte[index];
        System.arraycopy(input, 0, newInput, 0, index);
        return newInput;
    }

    private Set<Gem> loadLocalGems() {
        if (!this.isRubyGemsInstalled()) {
            return new HashSet<Gem>();
        }
        GemParser parser = new GemParser();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(LIST_COMMAND);
        commands.add(LOCAL_SWITCH);
        return parser.parse(this.execGemAndReadOutput(commands));
    }

    private String execGemAndReadOutput(List<String> commands) {
        ArrayList<String> commandsCopy = new ArrayList<String>(commands);
        String gemScriptPath = GemManager.getGemScriptPath();
        commandsCopy.add(0, gemScriptPath);
        File workingDirectory = new File(gemScriptPath).getParentFile();
        return this.execAndReadOutput(commandsCopy, workingDirectory);
    }

    private String execAndReadOutput(List<String> commands, File workingDirectory) {
        IVMInstall vm;
        ArrayList<String> line;
        block4: {
            line = new ArrayList<String>();
            vm = RubyRuntime.getDefaultVMInstall();
            if (vm != null) break block4;
            return "";
        }
        try {
            File executable = vm.getVMInstallType().findExecutable(vm.getInstallLocation());
            line.add(executable.getAbsolutePath());
            for (String command : commands) {
                line.add(command);
            }
            String[] cmdLine = new String[line.size()];
            cmdLine = line.toArray(cmdLine);
            Process p = DebugPlugin.exec((String[])cmdLine, (File)workingDirectory);
            return this.readInputStream(p.getInputStream());
        }
        catch (Exception e) {
            AptanaRDTPlugin.log(e);
            return "";
        }
    }

    private String readInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String liner = null;
        buffer = new StringBuffer();
        while ((liner = reader.readLine()) != null) {
            buffer.append(liner);
            buffer.append("\n");
            if (reader.ready()) continue;
            Thread.yield();
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    @Override
    public boolean update(Gem gem) {
        if (!this.isRubyGemsInstalled()) {
            return false;
        }
        try {
            String command = "update " + gem.getName();
            ILaunchConfiguration config = this.createGemLaunchConfiguration(command, true);
            final ILaunch launch = config.launch("run", null);
            Job job = new Job("Updating gem " + gem.getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    while (!launch.isTerminated()) {
                        Thread.yield();
                    }
                    GemManager.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (CoreException e) {
            AptanaRDTPlugin.log(e);
            return false;
        }
        return true;
    }

    private ILaunchConfigurationType getRubyApplicationConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType(IRubyLaunchConfigurationConstants.ID_RUBY_APPLICATION);
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private ILaunchConfiguration createGemLaunchConfiguration(String arguments, boolean isSudo) {
        String gemPath = GemManager.getGemScriptPath();
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getRubyApplicationConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(gemPath));
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, gemPath);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, RubyRuntime.getDefaultVMInstall().getName());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, RubyRuntime.getDefaultVMInstall().getVMInstallType().getId());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, arguments);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_IS_SUDO, isSudo);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(IRubyLaunchConfigurationConstants.ATTR_RUBY_COMMAND, EXECUTABLE);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, map);
            wc.setAttribute(IDebugUIConstants.ATTR_PRIVATE, true);
            wc.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, false);
            config = wc.doSave();
        }
        catch (CoreException coreException) {}
        return config;
    }

    private static String getGemScriptPath() {
        IVMInstall vm = RubyRuntime.getDefaultVMInstall();
        if (vm == null) {
            return null;
        }
        File installLocation = vm.getInstallLocation();
        String path = installLocation.getAbsolutePath();
        return String.valueOf(path) + File.separator + "bin" + File.separator + "gem";
    }

    @Override
    public boolean isRubyGemsInstalled() {
        String path = GemManager.getGemScriptPath();
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    @Override
    public boolean installGem(Gem gem) {
        return this.installGem(gem, true);
    }

    @Override
    public boolean installGem(Gem gem, boolean includeDependencies) {
        return this.installGem(gem, "http://gems.rubyforge.org", includeDependencies);
    }

    @Override
    public boolean removeGem(final Gem gem) {
        if (!this.isRubyGemsInstalled()) {
            return false;
        }
        try {
            String command = "uninstall " + gem.getName();
            if (gem.getVersion() != null && gem.getVersion().trim().length() > 0) {
                command = String.valueOf(command) + " -v " + gem.getVersion();
            }
            ILaunchConfiguration config = this.createGemLaunchConfiguration(command, true);
            final ILaunch launch = config.launch("run", null);
            Job job = new Job("Notifying gem listeners of uninstalled gem"){

                protected IStatus run(IProgressMonitor monitor) {
                    while (!launch.isTerminated()) {
                        Thread.yield();
                    }
                    GemManager.this.refresh();
                    for (GemListener listener : GemManager.this.listeners) {
                        listener.gemRemoved(gem);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (CoreException e) {
            AptanaRDTPlugin.log(e);
            return false;
        }
        return true;
    }

    @Override
    public Set<Gem> getGems() {
        return Collections.unmodifiableSortedSet(new TreeSet<Gem>(this.gems));
    }

    public static GemManager getInstance() {
        if (fgInstance == null) {
            fgInstance = new GemManager();
        }
        return fgInstance;
    }

    @Override
    public boolean refresh() {
        Set<Gem> newGems = this.loadLocalGems();
        this.gems = newGems;
        this.storeGemCache(this.gems, this.getConfigFile(LOCAL_GEMS_CACHE_FILE));
        for (GemListener listener : this.listeners) {
            listener.gemsRefreshed();
        }
        return true;
    }

    @Override
    public synchronized void addGemListener(GemListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Set<Gem> getRemoteGems() {
        return Collections.unmodifiableSortedSet(new TreeSet<Gem>(this.remoteGems));
    }

    @Override
    public Set<Gem> getRemoteGems(String sourceURL, IProgressMonitor monitor) {
        Set<Gem> gems;
        String indexFile = sourceURL;
        if (!indexFile.endsWith("/")) {
            indexFile = String.valueOf(indexFile) + "/";
        }
        if (!(gems = this.makeLogical(this.loadRemoteGems(String.valueOf(indexFile) + GEM_INDEX_FILE, monitor))).isEmpty()) {
            this.addSourceURL(sourceURL);
        }
        return Collections.unmodifiableSortedSet(new TreeSet<Gem>(gems));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set<String> loadSourceURLs(File file) {
        FileReader fileReader;
        block14: {
            Set<String> set;
            fileReader = null;
            try {
                fileReader = new FileReader(file);
                XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                SourceURLContentHandler handler = new SourceURLContentHandler();
                reader.setContentHandler(handler);
                reader.parse(new InputSource(fileReader));
                set = handler.getURLs();
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    break block14;
                    catch (SAXException e) {
                        AptanaRDTPlugin.log(e);
                        break block14;
                    }
                    catch (ParserConfigurationException e) {
                        AptanaRDTPlugin.log(e);
                        break block14;
                    }
                    catch (FactoryConfigurationError e) {
                        AptanaRDTPlugin.log(e);
                        break block14;
                    }
                    catch (IOException e) {
                        AptanaRDTPlugin.log(e);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fileReader == null) throw throwable;
                        fileReader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (fileReader == null) return set;
                fileReader.close();
                return set;
            }
            catch (IOException iOException) {}
            return set;
        }
        try {
            if (fileReader == null) return new HashSet<String>();
            fileReader.close();
            return new HashSet<String>();
        }
        catch (IOException iOException) {}
        return new HashSet<String>();
    }

    protected void addSourceURL(String sourceURL) {
        int length = this.urls.size();
        this.urls.add(sourceURL);
        if (this.urls.size() > length) {
            PrintWriter out = null;
            try {
                try {
                    out = new XMLWriter(new FileOutputStream(this.getConfigFile(SOURCE_URLS_CACHE_FILE)));
                    this.writeURLsXML(this.urls, (XMLWriter)out);
                }
                catch (FileNotFoundException e) {
                    AptanaRDTPlugin.log(e);
                }
                catch (IOException e) {
                    AptanaRDTPlugin.log(e);
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private void writeURLsXML(Set<String> urls, XMLWriter out) {
        out.startTag("sourceURLs", null);
        for (String url : urls) {
            out.printSimpleTag("url", url);
        }
        out.endTag("sourceURLs");
        out.flush();
    }

    @Override
    public Set<String> getSourceURLs() {
        return Collections.unmodifiableSet(new TreeSet<String>(this.urls));
    }

    @Override
    public boolean gemInstalled(String gemName) {
        Set<Gem> gems = this.getGems();
        for (Gem gem : gems) {
            if (!gem.getName().equalsIgnoreCase(gemName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void removeGemListener(GemListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public IPath getGemInstallPath() {
        List<IPath> paths = this.getGemInstallPaths();
        if (paths == null || paths.isEmpty()) {
            return null;
        }
        return paths.get(0);
    }

    @Override
    public List<IPath> getGemInstallPaths() {
        if (this.fGemInstallPaths == null) {
            String[] paths;
            block12: {
                String output;
                block11: {
                    block10: {
                        if (!this.isRubyGemsInstalled()) {
                            return null;
                        }
                        ILaunchConfiguration config = this.createGemLaunchConfiguration("", false);
                        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                        wc.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, true);
                        wc.setAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_CONSOLE, false);
                        File file = File.createTempFile("gem_manager", ".log");
                        wc.setAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_FILE, file.getAbsolutePath());
                        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, "");
                        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-r rubygems -e p(Gem.path)");
                        config = wc.doSave();
                        ILaunch launch = config.launch("run", (IProgressMonitor)new NullProgressMonitor());
                        while (!launch.isTerminated()) {
                            Thread.yield();
                        }
                        output = this.readInputStream(new FileInputStream(file));
                        if (file != null && !file.delete()) {
                            file.deleteOnExit();
                        }
                        if (output != null && output.trim().length() != 0) break block10;
                        return null;
                    }
                    if (output.startsWith("[") && output.endsWith("]")) break block11;
                    return null;
                }
                output = output.substring(1);
                output = output.substring(0, output.length() - 1);
                paths = output.split(",");
                if (paths != null && paths.length >= 1) break block12;
                return null;
            }
            try {
                ArrayList<IPath> installPaths = new ArrayList<IPath>();
                int i = 0;
                while (i < paths.length) {
                    String path = paths[i].trim();
                    path = path.substring(1);
                    path = path.substring(0, path.length() - 1);
                    installPaths.add((IPath)new Path(path.trim()));
                    ++i;
                }
                this.fGemInstallPaths = installPaths;
            }
            catch (Exception e) {
                AptanaRDTPlugin.log(e);
            }
        }
        return this.fGemInstallPaths;
    }

    @Override
    public IPath getGemPath(String gemName) {
        IPath path = this.getGemInstallPath();
        if (path == null) {
            return null;
        }
        File gemFolder = (path = path.append("gems")).toFile();
        File[] gems = gemFolder.listFiles();
        if (gems == null) {
            return null;
        }
        ArrayList<Path> matches = new ArrayList<Path>();
        int i = 0;
        while (i < gems.length) {
            File file = gems[i];
            String string = file.getName();
            if (string.startsWith(gemName)) {
                matches.add(new Path(file.getAbsolutePath()));
            }
            ++i;
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return ((IPath)matches.get(0)).append("lib");
        }
        ArrayList<GemVersion> versions = new ArrayList<GemVersion>();
        for (IPath iPath : matches) {
            String name = iPath.lastSegment();
            String version = name.substring(name.lastIndexOf("-") + 1);
            GemVersion duh = new GemVersion(version);
            versions.add(duh);
        }
        Collections.sort(versions);
        GemVersion gemVersion = (GemVersion)versions.get(versions.size() - 1);
        for (IPath iPath : matches) {
            String name = iPath.lastSegment();
            String version = name.substring(name.lastIndexOf("-") + 1);
            if (!version.equals(gemVersion.toString())) continue;
            return iPath.append("lib");
        }
        return null;
    }

    @Override
    public IPath getGemPath(String gemName, String version) {
        return this.getGemPath(String.valueOf(gemName) + "-" + version);
    }

    @Override
    public boolean updateAll() {
        if (!this.isRubyGemsInstalled()) {
            return false;
        }
        try {
            ILaunchConfiguration config = this.createGemLaunchConfiguration("update -y", true);
            final ILaunch launch = config.launch("run", null);
            Job job = new Job("Updating gem listing"){

                protected IStatus run(IProgressMonitor monitor) {
                    while (!launch.isTerminated()) {
                        Thread.yield();
                    }
                    GemManager.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (CoreException e) {
            AptanaRDTPlugin.log(e);
            return false;
        }
        return true;
    }

    @Override
    public void initialize() {
        this.urls = this.loadSourceURLs(this.getConfigFile(SOURCE_URLS_CACHE_FILE));
        if (this.urls.isEmpty()) {
            this.addSourceURL("http://gems.rubyforge.org");
            this.addSourceURL(RAILS_GEM_HOST);
        }
        this.gems = this.loadLocalCache(this.getConfigFile(LOCAL_GEMS_CACHE_FILE));
        this.remoteGems = this.makeLogical(this.loadLocalCache(this.getConfigFile(REMOTE_GEMS_CACHE_FILE)));
        RubyRuntime.addVMInstallChangedListener((IVMInstallChangedListener)new IVMInstallChangedListener(){

            public void vmRemoved(IVMInstall removedVm) {
            }

            public void vmChanged(PropertyChangeEvent event) {
            }

            public void vmAdded(IVMInstall newVm) {
            }

            public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
                GemManager.this.fGemInstallPaths = null;
                GemManager.this.refresh();
            }
        });
        this.scheduleLoadingLocalGems();
        this.scheduleLoadingRemoteGems();
    }

    private void scheduleLoadingLocalGems() {
        Job job2 = new Job(GemsMessages.GemManager_loading_local_gems){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    GemManager.this.gems = GemManager.this.loadLocalGems();
                    GemManager.this.storeGemCache(GemManager.this.gems, GemManager.this.getConfigFile(GemManager.LOCAL_GEMS_CACHE_FILE));
                    GemManager.this.isInitialized = true;
                    Set set = GemManager.this.listeners;
                    synchronized (set) {
                        for (GemListener listener : new ArrayList(GemManager.this.listeners)) {
                            listener.managerInitialized();
                        }
                    }
                    set = GemManager.this.listeners;
                    synchronized (set) {
                        for (GemListener listener : new ArrayList(GemManager.this.listeners)) {
                            listener.gemsRefreshed();
                        }
                    }
                }
                catch (Exception e) {
                    AptanaRDTPlugin.log(e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job2.schedule();
    }

    private void scheduleLoadingRemoteGems() {
        Job job = new Job(GemsMessages.GemManager_loading_remote_gems){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(GemsMessages.GemManager_loading_remote_gems, 100);
                    monitor.subTask("Loading up cached copy of remote gems");
                    GemManager.this.remoteGems = GemManager.this.loadLocalCache(GemManager.this.getConfigFile(GemManager.REMOTE_GEMS_CACHE_FILE));
                    monitor.worked(10);
                    GemManager.this.remoteGems = GemManager.this.loadRemoteGems(GemManager.DEFAULT_GEM_INDEX_URL, monitor);
                    monitor.worked(10);
                    monitor.subTask("Saving cache of remote gems");
                    GemManager.this.storeGemCache(GemManager.this.remoteGems, GemManager.this.getConfigFile(GemManager.REMOTE_GEMS_CACHE_FILE));
                    monitor.worked(5);
                    GemManager.this.remoteGems = GemManager.this.makeLogical(GemManager.this.remoteGems);
                    monitor.worked(5);
                }
                catch (Exception e) {
                    AptanaRDTPlugin.log(e);
                    monitor.setCanceled(true);
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected Set<Gem> makeLogical(Set<Gem> remoteGems) {
        TreeSet<Gem> sorted = new TreeSet<Gem>(remoteGems);
        TreeSet<LogicalGem> logical = new TreeSet<LogicalGem>();
        String name = null;
        HashSet<Gem> temp = new HashSet<Gem>();
        for (Gem gem : sorted) {
            if (name != null && !gem.getName().equals(name)) {
                logical.add(LogicalGem.create(temp));
                temp.clear();
            }
            name = gem.getName();
            temp.add(gem);
        }
        if (name != null && !temp.isEmpty()) {
            logical.add(LogicalGem.create(temp));
            temp.clear();
        }
        return Collections.unmodifiableSortedSet(logical);
    }

    @Override
    public boolean cleanup() {
        if (!this.isRubyGemsInstalled()) {
            return false;
        }
        try {
            String command = CLEANUP_COMMAND;
            ILaunchConfiguration config = this.createGemLaunchConfiguration(command, true);
            final ILaunch launch = config.launch("run", null);
            Job job = new Job("Cleaning up old versions of gems"){

                protected IStatus run(IProgressMonitor monitor) {
                    while (!launch.isTerminated()) {
                        Thread.yield();
                    }
                    GemManager.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (CoreException e) {
            AptanaRDTPlugin.log(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean installGem(Gem gem, String sourceURL) {
        return this.installGem(gem, sourceURL, true);
    }

    private boolean installGem(final Gem gem, String sourceURL, boolean includeDependencies) {
        if (!this.isRubyGemsInstalled()) {
            return false;
        }
        try {
            String command = "install " + gem.getName();
            if (gem.getVersion() != null && gem.getVersion().trim().length() > 0) {
                command = String.valueOf(command) + " -v " + gem.getVersion();
            }
            if (includeDependencies) {
                command = String.valueOf(command) + " -y";
            }
            if (sourceURL != null && !sourceURL.equals("http://gems.rubyforge.org")) {
                command = String.valueOf(command) + " --source " + sourceURL;
            }
            ILaunchConfiguration config = this.createGemLaunchConfiguration(command, true);
            final ILaunch launch = config.launch("run", null);
            Job job = new Job("Installing gem " + gem.getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    while (!launch.isTerminated()) {
                        Thread.yield();
                    }
                    GemManager.this.refresh();
                    for (GemListener listener : GemManager.this.listeners) {
                        listener.gemAdded(gem);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (CoreException e) {
            AptanaRDTPlugin.log(e);
            return false;
        }
        for (GemListener listener : this.listeners) {
            listener.gemAdded(gem);
        }
        return true;
    }
}

