/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.radrails.cloud.deploy;

import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.server.cloud.services.model.Event;
import com.aptana.ide.server.cloud.services.model.studio.StudioSite;
import com.aptana.ide.server.cloud.syncing.ICloudDeployer;
import com.aptana.radrails.cloud.deploy.Messages;
import com.aptana.radrails.cloud.internal.CloudUtil;
import com.aptana.radrails.cloud.internal.EndpointDialog;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.swt.widgets.Display;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.console.RailsShellFactory;

public class RailsCloudDeployer
implements ICloudDeployer {
    private static final String CAPFILE = "Capfile";

    public boolean supports(StudioSite site) {
        return site != null && site.isRails();
    }

    public IStatus deploy(StudioSite site, ICloudDeployer.Endpoint target, IProgressMonitor monitor) {
        monitor.beginTask(Messages.RailsCloudDeployer_LBL_Deploying_job_title, 100);
        IProject project = site.getProject().getLocalProject();
        final ICloudDeployer.Endpoint defaultChoice = target;
        final int[] dialogExit = new int[1];
        final ICloudDeployer.Endpoint[] endpointChoice = new ICloudDeployer.Endpoint[1];
        final String[] comment = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                EndpointDialog dialog = new EndpointDialog(Display.getDefault().getActiveShell(), defaultChoice);
                dialogExit[0] = dialog.open();
                endpointChoice[0] = dialog.getEndpoint();
                comment[0] = dialog.getComment();
            }
        });
        if (dialogExit[0] != 0) {
            return Status.CANCEL_STATUS;
        }
        target = endpointChoice[0];
        monitor.worked(2);
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 28);
        IStatus status = CloudUtil.installCloudGemIfNecessary((IProgressMonitor)sub);
        sub.done();
        if (!status.isOK()) {
            return status;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        new RailsShellFactory().openConsole();
        monitor.worked(1);
        sub = new SubProgressMonitor(monitor, 19);
        status = this.checkProjectHasBeenApCloudified(site, project, (IProgressMonitor)sub);
        sub.done();
        if (!status.isOK()) {
            return status;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        String targetName = "public";
        if (target == ICloudDeployer.Endpoint.STAGING) {
            targetName = "staging";
        }
        try {
            ILaunch launch = CloudUtil.run("apcloud", String.valueOf(targetName) + " " + "cloud:deploy", project, CloudUtil.getEnvMap(site), false);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    return Status.CANCEL_STATUS;
                }
                Thread.yield();
            }
            monitor.worked(45);
            if (launch.getProcesses() != null && launch.getProcesses()[0] != null && launch.getProcesses()[0].getExitValue() != 0) {
                return new Status(4, "com.aptana.radrails.cloud", -1, "Deployment failed", null);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        this.createEvent(site, endpointChoice[0], comment[0]);
        monitor.done();
        return Status.OK_STATUS;
    }

    private IStatus checkProjectHasBeenApCloudified(StudioSite site, IProject project, IProgressMonitor monitor) {
        IPath railsRoot = RailsPlugin.findRailsRoot((IProject)project);
        IFile file = project.getFile(railsRoot.append(CAPFILE));
        if (file.exists()) {
            return Status.OK_STATUS;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            ILaunch launch = CloudUtil.run("apcloudify", ".", project, CloudUtil.getEnvMap(site), true);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    return Status.CANCEL_STATUS;
                }
                Thread.yield();
            }
            if (launch.getProcesses() != null && launch.getProcesses()[0] != null && launch.getProcesses()[0].getExitValue() != 0) {
                return new Status(4, "com.aptana.radrails.cloud", -1, "Running apcloudify on project failed", null);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private void createEvent(StudioSite site, ICloudDeployer.Endpoint target, String comment) {
        User user = AptanaUser.getSignedInUser();
        String domainName = site.getPrimaryDomainName();
        if (target == ICloudDeployer.Endpoint.STAGING) {
            domainName = site.getStagingDomainName();
        }
        String subject = MessageFormat.format(Messages.RailsCloudDeployer_TTL_Deploy_event_subject, user.getUsername(), domainName);
        StringBuilder buffer = new StringBuilder(subject);
        if (comment != null && comment.length() > 0) {
            buffer.append("\n");
            buffer.append(Messages.RailsCloudDeployer_MSG_Deploy_event_comment_header);
            buffer.append("\n");
            buffer.append(comment);
            buffer.append("\n\n");
        }
        Event event = new Event(subject, buffer.toString());
        event.setId(Integer.toString(31));
        event.setLocation(site.getEvents().getLocation());
        event.setRequestBuilder(site.getRequestBuilder());
        event.setServiceProvider(site.getServiceProvider());
        event.setLogger(site.getLogger());
        event.commit();
        site.updateLastSync();
        site.getEvents().updateMaxSizeWithSeverities();
    }
}

