/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.yml.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class YMLActionGroup
extends ActionGroup {
    public static final String MENU_ID = "com.aptana.ide.editor.yml.source.menu";
    private static final String GROUP_COMMENT = "commentGroup";
    private ITextEditor fEditor;
    private String fGroupName;

    public YMLActionGroup(ITextEditor editor, String groupName) {
        this.fEditor = editor;
        this.fGroupName = groupName;
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        String menuText = "Source";
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        int added = 0;
        added = this.isEditorOwner() ? this.fillEditorSubMenu((IMenuManager)subMenu) : this.fillViewSubMenu((IMenuManager)subMenu);
        if (added > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    private int fillEditorSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        return added += this.addEditorAction(source, "ToggleComment");
    }

    private int fillViewSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        return added;
    }

    private int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }
}

