/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.yml;

import com.aptana.ide.editor.yml.YMLContributor;
import com.aptana.ide.editor.yml.YMLDocumentProvider;
import com.aptana.ide.editor.yml.YMLFileServiceFactory;
import com.aptana.ide.editor.yml.actions.YMLActionGroup;
import com.aptana.ide.editors.unified.DocumentSourceProvider;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.UnifiedConfiguration;
import com.aptana.ide.editors.unified.UnifiedEditor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ToggleCommentAction;

public class YMLEditor
extends UnifiedEditor {
    private YMLActionGroup fGenerateActionGroup;

    protected void initializeKeyBindingScopes() {
        super.initializeKeyBindingScopes();
        this.setKeyBindingScopes(new String[]{"com.aptana.ide.editors.UnifiedEditorsScope", "com.aptana.ide.editor.yml.ymlEditorScope"});
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        this.setToUseSpaces();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        this.setToUseSpaces();
    }

    private void setToUseSpaces() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IPreferenceStore store = this.getPreferenceStore();
        if (store == null) {
            return;
        }
        SourceViewerConfiguration sv = this.getSourceViewerConfiguration();
        int prefs = store.getInt("tabWidth");
        if (sv != null && sv instanceof UnifiedConfiguration) {
            UnifiedConfiguration uc = (UnifiedConfiguration)sv;
            uc.setTabWidth(prefs, true, sourceViewer);
        }
    }

    protected IUnifiedEditorContributor createLocalContributor() {
        return new YMLContributor();
    }

    public String getDefaultFileExtension() {
        return "yml";
    }

    public IFileServiceFactory getFileServiceFactory() {
        return YMLFileServiceFactory.getInstance();
    }

    public IDocumentProvider createDocumentProvider() {
        return YMLDocumentProvider.getInstance();
    }

    protected boolean isNewInput(IEditorInput input) {
        YMLDocumentProvider.YMLFileInfo cuInfo = this.getYMLFileInfo(input);
        if (cuInfo == null) {
            throw new RuntimeException("Error");
        }
        YMLDocumentProvider dp = (YMLDocumentProvider)this.getDocumentProvider();
        IDocument document = dp.getDocument(input);
        DocumentSourceProvider provider = new DocumentSourceProvider(document, input);
        if (provider == null) {
            throw new RuntimeException("Error");
        }
        return cuInfo.sourceProvider == null || !cuInfo.sourceProvider.equals(provider);
    }

    private YMLDocumentProvider.YMLFileInfo getYMLFileInfo(IEditorInput input) {
        YMLDocumentProvider dp = (YMLDocumentProvider)this.getDocumentProvider();
        if (dp == null) {
            throw new RuntimeException("Error");
        }
        return (YMLDocumentProvider.YMLFileInfo)dp.getFileInfoPublic(input);
    }

    protected void updateFileInfo(IEditorInput input, DocumentSourceProvider provider, IDocument document) {
        super.updateFileInfo(input, provider, document);
        if (this.isNewInput(input)) {
            this.getYMLFileInfo((IEditorInput)input).sourceProvider = provider;
        }
    }

    protected void createActions() {
        super.createActions();
        this.fGenerateActionGroup = new YMLActionGroup((ITextEditor)this, "group.edit");
        this.getSourceViewer().setDefaultPrefixes(new String[]{"#", ""}, "text/yaml");
        ToggleCommentAction action = new ToggleCommentAction(RubyPlugin.getDefault().getPluginProperties(), "ToggleCommentAction.", (ITextEditor)this){

            protected String[] getDefaultPrefixes(SourceViewerConfiguration configuration, ISourceViewer sourceViewer, String type) {
                return new String[]{"#", ""};
            }
        };
        action.setActionDefinitionId("com.aptana.ide.editor.yml.toggle.comment");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
    }

    private void configureToggleCommentAction() {
        IAction action = this.getAction("ToggleComment");
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.insertAfter("group.open", (IContributionItem)new GroupMarker("group.show"));
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fGenerateActionGroup.setContext(context);
        this.fGenerateActionGroup.fillContextMenu(menu);
        this.fGenerateActionGroup.setContext(null);
    }
}

