/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.VCallNode;
import org.jruby.evaluator.Instruction;
import org.jruby.runtime.Visibility;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

public class UnusedPrivateMethodVisitor
extends RubyLintVisitor {
    private Map<String, Node> privateMethods = new HashMap<String, Node>();
    private Set<String> usedMethods = new HashSet<String>();
    private Visibility visibility = Visibility.PUBLIC;

    public UnusedPrivateMethodVisitor(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        this.usedMethods.add(iVisited.getName());
        List args = ASTUtil.getArgumentNodesFromFunctionCall((IArgumentNode)iVisited);
        for (Node node : args) {
            if (!(node instanceof SymbolNode)) continue;
            this.usedMethods.add(((SymbolNode)node).getName());
        }
        return null;
    }

    public Instruction visitCallNode(CallNode iVisited) {
        Node receiver = iVisited.getReceiverNode();
        if (receiver instanceof SelfNode) {
            this.usedMethods.add(iVisited.getName());
        }
        return null;
    }

    public Instruction visitVCallNode(VCallNode iVisited) {
        this.usedMethods.add(iVisited.getName());
        if (iVisited.getName().equals("private")) {
            this.visibility = Visibility.PRIVATE;
        } else if (iVisited.getName().equals("protected")) {
            this.visibility = Visibility.PROTECTED;
        } else if (iVisited.getName().equals("public")) {
            this.visibility = Visibility.PUBLIC;
        }
        return null;
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        this.privateMethods.clear();
        this.usedMethods.clear();
        this.visibility = Visibility.PUBLIC;
        return null;
    }

    public void exitClassNode(ClassNode iVisited) {
        for (String name : this.usedMethods) {
            if (!this.privateMethods.containsKey(name)) continue;
            this.privateMethods.remove(name);
        }
        for (Node method : this.privateMethods.values()) {
            this.createProblem(method.getPosition(), "Unused private method " + ASTUtil.getNameReflectively((Node)method));
        }
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        if (this.visibility.isPrivate()) {
            this.privateMethods.put(iVisited.getName(), (Node)iVisited);
        }
        return null;
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.unusedPrivateMember";
    }

    protected int getProblemID() {
        return 603979894;
    }
}

