/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.Map;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.ReturnNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class TooManyReturnsVisitor
extends RubyLintVisitor {
    public static final int DEFAULT_MAX_RETURNS = 5;
    private int maxReturns = this.getInt("com.aptana.rdt.compiler.problem.maxReturns", 5);
    private int returnCount = 0;

    public TooManyReturnsVisitor(String contents) {
        this(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    public TooManyReturnsVisitor(Map options, String contents) {
        super(options, contents);
    }

    private int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt((String)this.fOptions.get(key));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.codeComplexityReturns";
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        this.returnCount = 0;
        return super.visitDefsNode(iVisited);
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.returnCount = 0;
        return super.visitDefnNode(iVisited);
    }

    public void exitDefnNode(DefnNode iVisited) {
        if (this.returnCount > this.maxReturns) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Too many explicit returns: " + this.returnCount);
        }
        this.returnCount = 0;
    }

    public void exitDefsNode(DefsNode iVisited) {
        if (this.returnCount > this.maxReturns) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Too many explicit returns: " + this.returnCount);
        }
        this.returnCount = 0;
        super.exitDefsNode(iVisited);
    }

    public Instruction visitReturnNode(ReturnNode iVisited) {
        ++this.returnCount;
        return super.visitReturnNode(iVisited);
    }
}

