/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarVariableNameVisitor
extends RubyLintVisitor {
    private Map<Node, Map<String, Node>> scopesToVars;
    private List<Node> scopes = new ArrayList<Node>();

    public SimilarVariableNameVisitor(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
        this.scopesToVars = new HashMap<Node, Map<String, Node>>();
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.similarVariableNames";
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.enterMethod((MethodDefNode)iVisited);
        return super.visitDefnNode(iVisited);
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        this.enterMethod((MethodDefNode)iVisited);
        return super.visitDefsNode(iVisited);
    }

    private void enterMethod(MethodDefNode node) {
        this.enterScope((Node)node);
    }

    public Instruction visitClassNode(ClassNode visited) {
        this.enterScope((Node)visited);
        return super.visitClassNode(visited);
    }

    public Instruction visitArgsNode(ArgsNode iVisited) {
        Node argNode;
        ListNode list = iVisited.getArgs();
        if (list != null && list.childNodes() != null) {
            for (Object arg : list.childNodes()) {
                argNode = (Node)arg;
                this.addVar((INameNode)argNode);
            }
        }
        if ((list = iVisited.getOptArgs()) != null && list.childNodes() != null) {
            for (Object arg : list.childNodes()) {
                argNode = (Node)arg;
                this.addVar((INameNode)argNode);
            }
        }
        return super.visitArgsNode(iVisited);
    }

    public void exitDefnNode(DefnNode iVisited) {
        this.exitMethod();
        super.exitDefnNode(iVisited);
    }

    public Instruction visitBlockNode(BlockNode iVisited) {
        this.enterScope((Node)iVisited);
        return super.visitBlockNode(iVisited);
    }

    private void enterScope(Node node) {
        this.scopes.add(node);
        this.scopesToVars.put(node, new HashMap());
    }

    public void exitBlockNode(BlockNode iVisited) {
        this.exitScope();
        super.exitBlockNode(iVisited);
    }

    private void exitClass() {
        this.exitScope(true);
    }

    private void exitScope() {
        this.exitScope(false);
    }

    private void exitScope(boolean exitingClass) {
        Map<String, Node> vars = this.getAllVarsInScope();
        this.pop();
        ArrayList names = new ArrayList(vars.keySet());
        while (!names.isEmpty()) {
            String name = (String)names.remove(0);
            boolean isInstanceVar = this.isInstanceVar(name);
            boolean isClassVar = this.isClassVar(name);
            if (!exitingClass && (isClassVar || isInstanceVar)) continue;
            for (String string : names) {
                String modName = name;
                if (isInstanceVar) {
                    if (!this.isInstanceVar(string)) continue;
                    modName = name.substring(1);
                    string = string.substring(1);
                } else if (isClassVar) {
                    if (!this.isClassVar(string)) continue;
                    modName = name.substring(2);
                    string = string.substring(2);
                } else if (this.isInstanceVar(string) || this.isClassVar(string)) continue;
                if (this.isPlural(modName, string) || this.isPlural(string, modName) || this.damerauLevenshteinDistance(modName, string) > this.levenshteinThreshold(modName)) continue;
                this.createProblem(vars.get(name).getPosition(), "Variable has similar name to another in scope: Possible misspelling.");
            }
        }
    }

    private Map<String, Node> getAllVarsInScope() {
        HashMap<String, Node> all = new HashMap<String, Node>();
        for (Node scopeNode : this.scopes) {
            all.putAll(this.scopesToVars.get(scopeNode));
        }
        return all;
    }

    private void pop() {
        Node scopeNode = this.scopes.remove(this.scopes.size() - 1);
        this.scopesToVars.remove(scopeNode);
    }

    private boolean isPlural(String singular, String plural) {
        return singular.length() == plural.length() - 1 && singular.equals(plural.substring(0, plural.length() - 1)) && plural.charAt(plural.length() - 1) == 's';
    }

    private boolean isInstanceVar(String name) {
        return !this.isClassVar(name) && name.startsWith("@");
    }

    private boolean isClassVar(String name) {
        return name.startsWith("@@");
    }

    private int levenshteinThreshold(String name) {
        int length = name.length();
        if (length < 3) {
            return 0;
        }
        return (int)Math.ceil((float)length / 5.0f);
    }

    private int damerauLevenshteinDistance(String s, String t) {
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int m = s.length();
        int n = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[m + 1][n + 1];
        int i = 0;
        while (i <= m) {
            d[i][0] = i;
            ++i;
        }
        int j = 1;
        while (j <= n) {
            d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= m) {
            int j2 = 1;
            while (j2 <= n) {
                int cost = s.charAt(i - 1) == t.charAt(j2 - 1) ? 0 : 1;
                d[i][j2] = this.minimum(d[i - 1][j2] + 1, d[i][j2 - 1] + 1, d[i - 1][j2 - 1] + cost);
                if (i > 1 && j2 > 1 && s.charAt(i - 1) == t.charAt(j2 - 2) && s.charAt(i - 2) == t.charAt(j2 - 1)) {
                    d[i][j2] = this.minimum(d[i][j2], d[i - 2][j2 - 2] + cost);
                }
                ++j2;
            }
            ++i;
        }
        return d[m][n];
    }

    private int minimum(int i, int j, int k) {
        int min = this.minimum(i, j);
        return this.minimum(min, k);
    }

    private int minimum(int x, int y) {
        if (x < y) {
            return x;
        }
        return y;
    }

    public Instruction visitVCallNode(VCallNode iVisited) {
        this.addVar((INameNode)iVisited);
        return super.visitVCallNode(iVisited);
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.addVar((INameNode)iVisited);
        return super.visitLocalAsgnNode(iVisited);
    }

    public Instruction visitLocalVarNode(LocalVarNode iVisited) {
        this.addVar((INameNode)iVisited);
        return super.visitLocalVarNode(iVisited);
    }

    private void addToClass(INameNode iVisited) {
        int i = 1;
        Node scopeNode = null;
        do {
            if (!((scopeNode = this.scopes.get(this.scopes.size() - i)) instanceof ClassNode) && !(scopeNode instanceof SClassNode) && !(scopeNode instanceof RootNode)) continue;
            this.addToScope(iVisited, scopeNode);
            break;
        } while (++i <= this.scopes.size());
    }

    private void addVar(INameNode iVisited) {
        Node scopeNode = this.scopes.get(this.scopes.size() - 1);
        this.addToScope(iVisited, scopeNode);
    }

    private void addToScope(INameNode iVisited, Node scopeNode) {
        Map<String, Node> vars = this.scopesToVars.get(scopeNode);
        if (vars == null) {
            vars = new HashMap<String, Node>();
        }
        vars.put(iVisited.getName(), (Node)iVisited);
    }

    public Instruction visitRootNode(RootNode visited) {
        this.enterScope((Node)visited);
        return super.visitRootNode(visited);
    }

    public void exitClassNode(ClassNode iVisited) {
        this.exitClass();
    }

    public void exitDefsNode(DefsNode iVisited) {
        this.exitMethod();
        super.exitDefsNode(iVisited);
    }

    private void exitMethod() {
        this.exitScope();
    }

    public Instruction visitInstAsgnNode(InstAsgnNode iVisited) {
        this.addToClass((INameNode)iVisited);
        return super.visitInstAsgnNode(iVisited);
    }

    public Instruction visitInstVarNode(InstVarNode iVisited) {
        this.addToClass((INameNode)iVisited);
        return super.visitInstVarNode(iVisited);
    }

    public Instruction visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        this.addToClass((INameNode)iVisited);
        return super.visitClassVarAsgnNode(iVisited);
    }

    public Instruction visitClassVarNode(ClassVarNode iVisited) {
        this.addToClass((INameNode)iVisited);
        return super.visitClassVarNode(iVisited);
    }

    public Instruction visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        this.addToClass((INameNode)iVisited);
        return super.visitClassVarDeclNode(iVisited);
    }
}

