/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

public class LocalsMaskingMethodsVisitor
extends RubyLintVisitor {
    private ArrayList<LocalAsgnNode> locals = new ArrayList();
    private HashSet<String> methods = new HashSet();

    public LocalsMaskingMethodsVisitor(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.localVariableMasksMethod";
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        this.methods.clear();
        this.locals.clear();
        return null;
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        String name = iVisited.getName();
        if (name.equals("attr_accessor") || name.equals("attr")) {
            List args = ASTUtil.getArgumentsFromFunctionCall((IArgumentNode)iVisited);
            if (name.equals("attr")) {
                this.methods.add((String)args.get(0));
            } else {
                this.methods.addAll(args);
            }
        }
        return super.visitFCallNode(iVisited);
    }

    public void exitClassNode(ClassNode iVisited) {
        this.findMaskingLocals();
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.methods.add(iVisited.getName());
        return null;
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.locals.add(iVisited);
        return null;
    }

    private void findMaskingLocals() {
        for (LocalAsgnNode local : this.locals) {
            if (!this.methods.contains(local.getName())) continue;
            this.createProblem(local.getPosition(), "Local variable hides method");
        }
    }
}

