/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class ComparableInclusionVisitor
extends RubyLintVisitor {
    private static final String INCLUDE = "include";
    private static final String COMPARABLE_METHOD = "<=>";
    private static final String COMPARABLE = "Comparable";
    private boolean includedComparable = false;
    private boolean definedComparableMethod;
    private ISourcePosition pos;

    public ComparableInclusionVisitor(String code) {
        super(AptanaRDTPlugin.getDefault().getOptions(), code);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.comparableMissingMethod";
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        if (this.includedComparable) {
            return null;
        }
        String callName = iVisited.getName();
        if (!callName.equals(INCLUDE)) {
            return null;
        }
        Node args = iVisited.getArgsNode();
        if (args instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)args;
            for (Object arg : array.childNodes()) {
                ConstNode constNode;
                if (!(arg instanceof ConstNode) || !(constNode = (ConstNode)arg).getName().equals(COMPARABLE)) continue;
                this.pos = constNode.getPosition();
                this.includedComparable = true;
                return null;
            }
        }
        return null;
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        String methodName = iVisited.getName();
        if (methodName.equals(COMPARABLE_METHOD)) {
            this.definedComparableMethod = true;
        }
        return super.visitDefnNode(iVisited);
    }

    public void exitClassNode(ClassNode iVisited) {
        if (this.includedComparable && !this.definedComparableMethod) {
            this.createProblem(this.pos, "Included comparable but did not define a <=> method");
        }
        this.includedComparable = false;
        this.pos = null;
        this.definedComparableMethod = false;
    }

    protected int getProblemID() {
        return 132;
    }
}

