/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import org.jruby.ast.AndNode;
import org.jruby.ast.Node;
import org.jruby.ast.OrNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

public class AndOrUsedOnRighthandAssignment
extends RubyLintVisitor {
    public AndOrUsedOnRighthandAssignment(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.assignmentPrecedence";
    }

    public Instruction visitOrNode(OrNode iVisited) {
        Node leftHand = iVisited.getFirstNode();
        if (this.isAssignment(leftHand)) {
            this.createProblem(iVisited.getPosition(), this.createMessage((Node)iVisited));
        }
        return super.visitOrNode(iVisited);
    }

    public Instruction visitAndNode(AndNode iVisited) {
        Node leftHand = iVisited.getFirstNode();
        if (this.isAssignment(leftHand)) {
            this.createProblem(iVisited.getPosition(), this.createMessage((Node)iVisited));
        }
        return super.visitAndNode(iVisited);
    }

    private String createMessage(Node iVisited) {
        Node rightHand;
        Node leftHand;
        String type;
        if (iVisited instanceof AndNode) {
            type = "and";
            leftHand = ((AndNode)iVisited).getFirstNode();
            rightHand = ((AndNode)iVisited).getSecondNode();
        } else {
            type = "or";
            leftHand = ((OrNode)iVisited).getFirstNode();
            rightHand = ((OrNode)iVisited).getSecondNode();
        }
        StringBuffer message = new StringBuffer();
        message.append("Assignment will happen before '");
        message.append(type);
        message.append("' comparison. Assignment looks like: (");
        message.append(this.getSource(leftHand));
        message.append(") ");
        message.append(type);
        message.append(" (");
        message.append(this.getSource(rightHand));
        message.append(")");
        return message.toString();
    }

    private boolean isAssignment(Node node) {
        return ASTUtil.isAssignment((Node)node);
    }
}

