/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.Version;
import com.aptana.rdt.internal.core.gems.GemOnePointTwoParser;
import com.aptana.rdt.internal.core.gems.GemParseException;
import com.aptana.rdt.internal.core.gems.GemParser;
import com.aptana.rdt.internal.core.gems.IGemParser;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybridGemParser
implements IGemParser {
    private IGemParser[] parsers;

    public HybridGemParser(Version version) {
        this.parsers = version != null && version.isLessThan("1.2.0") ? new IGemParser[]{new GemParser(true), new GemOnePointTwoParser(true)} : new IGemParser[]{new GemOnePointTwoParser(true), new GemParser(true)};
    }

    @Override
    public Set<Gem> parse(String string) {
        int i = 0;
        while (i < this.parsers.length) {
            try {
                Set<Gem> gems = this.parsers[i].parse(string);
                if (gems != null && !gems.isEmpty()) {
                    return gems;
                }
            }
            catch (GemParseException e) {
                AptanaRDTPlugin.log(e);
            }
            ++i;
        }
        return Collections.emptySet();
    }
}

