/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core.gems;

import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.internal.core.gems.GemParseException;
import com.aptana.rdt.internal.core.gems.GemParser;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GemOnePointTwoParser
extends GemParser {
    private static final Pattern NAME_AND_VERSION_PATTERN = Pattern.compile("^\\S+\\s+\\(.+\\)\\z");

    GemOnePointTwoParser(String string) {
        super(string);
    }

    GemOnePointTwoParser(boolean strict) {
        super(strict);
    }

    @Override
    protected Set<Gem> parseOutGems(List<String> lines) throws GemParseException {
        HashSet<Gem> gems = new HashSet<Gem>();
        if (lines == null || lines.isEmpty()) {
            return gems;
        }
        if (lines.get(0).startsWith("ERROR:")) {
            return gems;
        }
        String nameAndVersion = null;
        String description = null;
        while (true) {
            if (!lines.isEmpty()) {
                String nextLine = lines.remove(0);
                if (nameAndVersion == null) {
                    nameAndVersion = nextLine;
                    continue;
                }
                if (nextLine.trim().length() == 0 && description == null) {
                    description = nextLine;
                    continue;
                }
                if (description == null) continue;
                Matcher m = NAME_AND_VERSION_PATTERN.matcher(nextLine);
                if (m.find()) {
                    lines.add(0, nextLine);
                } else {
                    description = String.valueOf(description) + " " + nextLine.trim();
                    continue;
                }
            }
            if (description == null) {
                if (this.strict) {
                    throw new GemParseException("Doesn't appear to be RubyGems 1.2+ listing format.");
                }
                return gems;
            }
            int openParen = nameAndVersion.indexOf(40);
            int closeParen = nameAndVersion.indexOf(41);
            String name = nameAndVersion.substring(0, openParen);
            String version = nameAndVersion.substring(openParen + 1, closeParen);
            if (version.indexOf(",") != -1) {
                String[] versions = version.split(", ");
                int y = 0;
                while (y < versions.length) {
                    gems.add(new Gem(name.trim(), versions[y], description.trim()));
                    ++y;
                }
            } else {
                gems.add(new Gem(name.trim(), version, description.trim()));
            }
            nameAndVersion = null;
            description = null;
            if (lines.isEmpty()) break;
        }
        return gems;
    }
}

