/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.IAptanaProxyService;
import com.aptana.rdt.core.gems.AbstractGemManager;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.GemListener;
import com.aptana.rdt.core.gems.GemRequirement;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.core.gems.LogicalGem;
import com.aptana.rdt.core.gems.Version;
import com.aptana.rdt.internal.core.SystemPropertyProxyService;
import com.aptana.rdt.internal.core.gems.GemParseException;
import com.aptana.rdt.internal.core.gems.GemsMessages;
import com.aptana.rdt.internal.core.gems.HybridGemParser;
import com.aptana.rdt.internal.core.gems.IGemParser;
import com.aptana.rdt.internal.core.gems.XMLWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallChangedListener;
import org.rubypeople.rdt.launching.PropertyChangeEvent;
import org.rubypeople.rdt.launching.RubyRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemManager
extends AbstractGemManager
implements IGemManager,
IVMInstallChangedListener {
    private static final String DETAIL_SWITCH = "-d";
    private static final String SOURCE_SWITCH = "--source";
    private static final String INCLUDE_DEPENDENCIES_SWITCH = "-y";
    private static final String LOCAL_SWITCH = "-l";
    private static final String VERSION_SWITCH = "-v";
    private static final String REMOTE_SWITCH = "-r";
    private static final String LIST_COMMAND = "list";
    private static final String INSTALL_COMMAND = "install";
    private static final String UNINSTALL_COMMAND = "uninstall";
    private static final String UPDATE_COMMAND = "update";
    private static final String CLEANUP_COMMAND = "cleanup";
    private static final String EXECUTABLE = "ruby";
    private static final String LOCAL_GEMS_CACHE_FILE = "local_gems.xml";
    private static final String RUBYGEMS_UPDATE_GEM_NAME = "rubygems-update";
    private static final String UPDATE_RUBYGEMS_COMMAND = "update_rubygems";
    private static GemManager fgInstance;
    private Set<Gem> gems;
    private Set<String> urls;
    private List<IPath> fGemInstallPaths;
    private Map<String, Set<Gem>> fRemoteGems = new HashMap<String, Set<Gem>>();
    protected boolean isInitialized;
    private Version fVersion;
    private static int seed;

    static {
        seed = 0;
    }

    protected GemManager() {
        this.urls = new HashSet<String>();
        this.gems = new HashSet<Gem>();
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    /*
     * Exception decompiling
     */
    protected Set<Gem> loadLocalCache(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void storeGemCache(Set<Gem> gems, File file) {
        PrintWriter out = null;
        try {
            try {
                out = new XMLWriter(new FileOutputStream(file));
                this.writeXML(gems, (XMLWriter)out);
                return;
            }
            catch (FileNotFoundException e) {
                AptanaRDTPlugin.log(e);
                if (out == null) return;
                out.close();
                return;
            }
            catch (IOException e) {
                AptanaRDTPlugin.log(e);
                if (out == null) return;
                out.close();
                return;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected File getConfigFile(String fileName) {
        return AptanaRDTPlugin.getDefault().getStateLocation().append(fileName).toFile();
    }

    private void writeXML(Set<Gem> gems, XMLWriter out) {
        out.startTag("gems", null);
        for (Gem gem : gems) {
            out.startTag("gem", null);
            out.printSimpleTag("name", gem.getName());
            out.printSimpleTag("version", gem.getVersion());
            out.printSimpleTag("description", gem.getDescription());
            out.printSimpleTag("platform", gem.getPlatform());
            out.endTag("gem");
        }
        out.endTag("gems");
        out.flush();
    }

    protected Set<Gem> loadRemoteGems(String gemIndexUrl, IProgressMonitor monitor) {
        if (!this.isRubyGemsInstalled()) {
            return new HashSet<Gem>();
        }
        IGemParser parser = this.getGemParser();
        String output = this.getRemoteGemsListing(gemIndexUrl);
        try {
            return parser.parse(output);
        }
        catch (GemParseException gemParseException) {
            return Collections.emptySet();
        }
    }

    protected IGemParser getGemParser() {
        return new HybridGemParser(this.getVersion());
    }

    private Set<Gem> loadLocalGems(IProgressMonitor monitor) {
        if (!this.isRubyGemsInstalled()) {
            return new HashSet<Gem>();
        }
        IGemParser parser = this.getGemParser();
        String output = this.getLocalGemsListing();
        try {
            return parser.parse(output);
        }
        catch (GemParseException gemParseException) {
            return Collections.emptySet();
        }
    }

    private String launchInBackgroundAndRead(ILaunchConfiguration config, File file) {
        return RubyRuntime.launchInBackgroundAndRead((ILaunchConfiguration)config, (File)file);
    }

    private String launchInBackgroundAndRead(String command, File file) {
        return this.launchInBackgroundAndRead(this.createGemLaunchConfiguration(command, false), file);
    }

    @Override
    public Version getVersion() {
        if (this.fVersion != null) {
            return this.fVersion;
        }
        int tries = 0;
        while (this.fVersion == null && tries < 3) {
            String version = this.launchInBackgroundAndRead(VERSION_SWITCH, this.getStateFile("version.txt"));
            try {
                if (version != null && version.trim().length() > 0) {
                    this.fVersion = new Version(version.trim());
                }
            }
            catch (RuntimeException e) {
                AptanaRDTPlugin.log(e);
                this.fVersion = null;
            }
            ++tries;
        }
        return this.fVersion;
    }

    private String getLocalGemsListing() {
        String command = "query -d";
        if (this.getVersion() != null && this.getVersion().isLessThanOrEqualTo("0.9.3")) {
            command = "list -l";
        }
        return this.launchInBackgroundAndRead(command, this.getGemListingFile());
    }

    private String getRemoteGemsListing(String sourceURL) {
        String command = "list -d -r --source " + sourceURL;
        return this.launchInBackgroundAndRead(command, this.getStateFile("remote_listing.txt"));
    }

    private File getGemListingFile() {
        return this.getStateFile("local_listing.txt");
    }

    @Override
    public IStatus update(Gem gem, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!this.isRubyGemsInstalled()) {
            return new Status(4, "com.aptana.rdt", -1, "RubyGems not installed", null);
        }
        try {
            String command = "update " + gem.getName();
            command = this.addProxy(command);
            ILaunchConfiguration config = this.createGemLaunchConfiguration(command, true);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ILaunch launch = config.launch("run", monitor);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    try {
                        launch.terminate();
                    }
                    catch (DebugException debugException) {}
                    return Status.CANCEL_STATUS;
                }
                Thread.yield();
            }
            this.refresh(monitor);
            for (GemListener listener : new ArrayList(this.listeners)) {
                listener.gemUpdated(gem);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    private ILaunchConfigurationType getRubyApplicationConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType(IRubyLaunchConfigurationConstants.ID_RUBY_APPLICATION);
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private ILaunchConfiguration createGemLaunchConfiguration(String arguments, boolean isSudo) {
        String gemPath = GemManager.getGemScriptPath();
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getRubyApplicationConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getUniqueName(gemPath));
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, gemPath);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, RubyRuntime.getDefaultVMInstall().getName());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, RubyRuntime.getDefaultVMInstall().getVMInstallType().getId());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, arguments);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_IS_SUDO, isSudo);
            if (isSudo) {
                wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_TERMINAL_COMMAND, "gem " + arguments);
                wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL, "org.radrails.rails.shell");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(IRubyLaunchConfigurationConstants.ATTR_RUBY_COMMAND, EXECUTABLE);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, map);
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            AptanaRDTPlugin.log(ce);
        }
        return config;
    }

    private synchronized String getUniqueName(String name) {
        String unique = String.valueOf(this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name)) + seed++;
        return unique;
    }

    @Override
    public ILaunchConfiguration run(String args) throws CoreException {
        boolean useSudo = false;
        if ((args.contains("install ") || args.contains(UPDATE_COMMAND) || args.contains("uninstall ") || args.contains(CLEANUP_COMMAND)) && !args.contains("help ")) {
            useSudo = true;
        }
        return this.createGemLaunchConfiguration(args, useSudo);
    }

    private static String getGemScriptPath() {
        IVMInstall vm = RubyRuntime.getDefaultVMInstall();
        if (vm == null) {
            return null;
        }
        File installLocation = vm.getInstallLocation();
        String path = installLocation.getAbsolutePath();
        return String.valueOf(path) + File.separator + "bin" + File.separator + "gem";
    }

    @Override
    public boolean isRubyGemsInstalled() {
        String path = GemManager.getGemScriptPath();
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    @Override
    public IStatus installGem(Gem gem, IProgressMonitor monitor) {
        return this.installGem(gem, true, monitor);
    }

    @Override
    public IStatus installGem(Gem gem, boolean includeDependencies, IProgressMonitor monitor) {
        if (gem.isLocal()) {
            return this.doLocalInstallGem(gem, monitor);
        }
        return this.installGem(gem, "http://gems.rubyforge.org", includeDependencies, monitor);
    }

    @Override
    public IStatus removeGem(Gem gem, IProgressMonitor monitor) {
        if (!this.isRubyGemsInstalled()) {
            return new Status(4, "com.aptana.rdt", -1, "RubyGems not installed", null);
        }
        try {
            String command = "uninstall " + gem.getName();
            if (gem.getVersion() != null && gem.getVersion().trim().length() > 0) {
                command = String.valueOf(command) + " -v " + gem.getVersion();
            }
            ILaunchConfiguration config = this.createGemLaunchConfiguration(command, true);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ILaunch launch = config.launch("run", monitor);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    return Status.CANCEL_STATUS;
                }
                Thread.yield();
            }
            this.refresh(monitor);
            for (GemListener listener : new ArrayList(this.listeners)) {
                listener.gemRemoved(gem);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    @Override
    public Set<Gem> getGems() {
        return Collections.unmodifiableSortedSet(new TreeSet<Gem>(this.gems));
    }

    public static GemManager getInstance() {
        if (fgInstance == null) {
            fgInstance = new GemManager();
        }
        return fgInstance;
    }

    @Override
    public IStatus refresh(IProgressMonitor monitor) {
        Set<Gem> newGems = this.loadLocalGems(monitor);
        this.gems = newGems;
        this.storeGemCache(this.gems, this.getConfigFile(LOCAL_GEMS_CACHE_FILE));
        Job job = new Job("notifying Gem Listeners of refresh"){

            protected IStatus run(IProgressMonitor monitor) {
                for (GemListener listener : new ArrayList(GemManager.this.listeners)) {
                    listener.gemsRefreshed();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return Status.OK_STATUS;
    }

    @Override
    public Set<Gem> getRemoteGems() {
        return this.getRemoteGems("http://gems.rubyforge.org", (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public Set<Gem> getRemoteGems(String sourceURL, IProgressMonitor monitor) {
        Set<Object> remoteGems = new HashSet();
        if (this.fRemoteGems.containsKey(sourceURL)) {
            remoteGems = this.fRemoteGems.get(sourceURL);
        } else {
            remoteGems = this.makeLogical(this.loadRemoteGems(sourceURL, monitor));
            if (!remoteGems.isEmpty()) {
                this.addSourceURL(sourceURL);
                this.fRemoteGems.put(sourceURL, remoteGems);
            }
        }
        return Collections.unmodifiableSortedSet(new TreeSet<Object>(remoteGems));
    }

    protected void addSourceURL(String sourceURL) {
        if (this.urls.contains(sourceURL)) {
            return;
        }
        this.launchInBackgroundAndRead("sources -a " + sourceURL, this.getConfigFile("add_source.txt"));
        this.urls.add(sourceURL);
    }

    @Override
    public Set<String> getSourceURLs() {
        return Collections.unmodifiableSet(new TreeSet<String>(this.urls));
    }

    @Override
    public boolean gemInstalled(String gemName) {
        Set<Gem> gems = this.getGems();
        for (Gem gem : gems) {
            if (!gem.getName().equalsIgnoreCase(gemName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IPath> getGemInstallPaths() {
        if (this.fGemInstallPaths == null) {
            if (!this.isRubyGemsInstalled()) {
                return null;
            }
            ILaunchConfiguration config = this.createGemLaunchConfiguration("", false);
            try {
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-r rubygems -e p(Gem.path)");
                config = wc.doSave();
            }
            catch (CoreException e) {
                AptanaRDTPlugin.log(e);
            }
            try {
                String output = this.launchInBackgroundAndRead(config, this.getGemInstallPathFile());
                this.fGemInstallPaths = this.parseInstallPaths(output);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fGemInstallPaths = null;
                return null;
            }
        }
        return this.fGemInstallPaths;
    }

    private List<IPath> parseInstallPaths(String output) {
        String[] paths;
        block6: {
            if (output == null || output.trim().length() == 0) {
                throw new IllegalArgumentException("Got empty output for gem install paths");
            }
            if (!(output = output.trim()).startsWith("[") || !output.endsWith("]")) {
                throw new IllegalArgumentException("Expected an array for gem install paths, but was: " + output);
            }
            paths = (output = output.substring(1, output.length() - 1)).split(",");
            if (paths != null && paths.length >= 1) break block6;
            return null;
        }
        try {
            ArrayList<IPath> installPaths = new ArrayList<IPath>();
            int i = 0;
            while (i < paths.length) {
                String path = paths[i].trim();
                path = path.substring(1, path.length() - 1);
                installPaths.add((IPath)new Path(path.trim()));
                ++i;
            }
            return installPaths;
        }
        catch (Exception e) {
            AptanaRDTPlugin.log(e);
            return null;
        }
    }

    private File getGemInstallPathFile() {
        return this.getStateFile("install_path.txt");
    }

    private File getStateFile(String name) {
        String currentVMId = RubyRuntime.getDefaultVMInstall().getId();
        File file = AptanaRDTPlugin.getDefault().getStateLocation().append("gems").append(currentVMId).append(name).toFile();
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException iOException) {}
        return file;
    }

    @Override
    public IPath getGemPath(String gemName) {
        String version;
        List<IPath> paths = this.getGemInstallPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<Path> matches = new ArrayList<Path>();
        for (IPath path : paths) {
            File file = (path = path.append("gems")).toFile();
            File[] gems = file.listFiles();
            if (gems == null) continue;
            int i = 0;
            while (i < gems.length) {
                File gem = gems[i];
                String name = gem.getName();
                if (name.startsWith(gemName)) {
                    matches.add(new Path(gem.getAbsolutePath()));
                }
                ++i;
            }
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return ((IPath)matches.get(0)).append("lib");
        }
        ArrayList<Version> versions = new ArrayList<Version>();
        block6: for (IPath iPath : matches) {
            String name = iPath.lastSegment();
            String[] parts = name.split("-");
            int i = parts.length - 1;
            while (i >= 0) {
                version = parts[i];
                if (Version.correctFormat(version)) {
                    try {
                        Version duh = new Version(version);
                        versions.add(duh);
                        continue block6;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                --i;
            }
        }
        Collections.sort(versions);
        Version version2 = (Version)versions.get(versions.size() - 1);
        for (IPath iPath : matches) {
            String name = iPath.lastSegment();
            String[] parts = name.split("-");
            version = null;
            int i = parts.length - 1;
            while (i >= 0) {
                if (Version.correctFormat(parts[i])) {
                    version = parts[i];
                    try {
                        Version duh = new Version(version);
                        versions.add(duh);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                --i;
            }
            if (version == null || !version.equals(version2.toString())) continue;
            return iPath.append("lib");
        }
        return null;
    }

    @Override
    public IPath getGemPath(String gemName, String version) {
        return this.getGemPath(String.valueOf(gemName) + "-" + version);
    }

    @Override
    public IStatus updateAll(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!this.isRubyGemsInstalled()) {
            return new Status(4, "com.aptana.rdt", "RubyGems not installed", null);
        }
        IStatus result = this.updateSystem(monitor);
        if (result != null && !result.isOK()) {
            return result;
        }
        try {
            ILaunchConfiguration config = this.createGemLaunchConfiguration(this.addProxy("update -y"), true);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ILaunch launch = config.launch("run", monitor);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    return Status.CANCEL_STATUS;
                }
                Thread.yield();
            }
            this.refresh(monitor);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    @Override
    public void initialize() {
        RubyRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
        this.scheduleLoadingSources();
        this.scheduleLoadingLocalGems();
    }

    private void scheduleLoadingSources() {
        Job job = new Job("Loading Remote Gem Sources"){

            protected IStatus run(IProgressMonitor monitor) {
                GemManager.this.urls = GemManager.this.loadSourceURLs();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setSystem(true);
        job.schedule();
    }

    protected Set<String> loadSourceURLs() {
        HashSet<String> sources = new HashSet<String>();
        String output = this.launchInBackgroundAndRead("sources -l", this.getConfigFile("sources_list.txt"));
        if (output == null) {
            return sources;
        }
        String[] lines = output.split("\n");
        if (lines == null) {
            return sources;
        }
        int i = 2;
        while (i < lines.length) {
            sources.add(lines[i].trim());
            ++i;
        }
        return sources;
    }

    private void scheduleLoadingLocalGems() {
        Job job = new Job(GemsMessages.GemManager_loading_local_gems){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    GemManager.this.gems = GemManager.this.loadLocalCache(GemManager.this.getConfigFile(GemManager.LOCAL_GEMS_CACHE_FILE));
                    for (GemListener listener : new ArrayList(GemManager.this.listeners)) {
                        listener.gemsRefreshed();
                    }
                    GemManager.this.gems = GemManager.this.loadLocalGems(monitor);
                    int tries = 0;
                    while (GemManager.this.gems.isEmpty() && tries < 3) {
                        ++tries;
                        GemManager.this.gems = GemManager.this.loadLocalGems(monitor);
                    }
                    GemManager.this.storeGemCache(GemManager.this.gems, GemManager.this.getConfigFile(GemManager.LOCAL_GEMS_CACHE_FILE));
                    GemManager.this.isInitialized = true;
                    for (GemListener listener : new ArrayList(GemManager.this.listeners)) {
                        listener.managerInitialized();
                    }
                    for (GemListener listener : new ArrayList(GemManager.this.listeners)) {
                        listener.gemsRefreshed();
                    }
                }
                catch (Exception e) {
                    AptanaRDTPlugin.log(e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setSystem(true);
        job.schedule();
    }

    protected Set<Gem> makeLogical(Set<Gem> remoteGems) {
        TreeSet<Gem> sorted = new TreeSet<Gem>(remoteGems);
        TreeSet<LogicalGem> logical = new TreeSet<LogicalGem>();
        String name = null;
        HashSet<Gem> temp = new HashSet<Gem>();
        for (Gem gem : sorted) {
            if (name != null && !gem.getName().equals(name)) {
                logical.add(LogicalGem.create(temp));
                temp.clear();
            }
            name = gem.getName();
            temp.add(gem);
        }
        if (name != null && !temp.isEmpty()) {
            logical.add(LogicalGem.create(temp));
            temp.clear();
        }
        return Collections.unmodifiableSortedSet(logical);
    }

    @Override
    public IStatus cleanup(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!this.isRubyGemsInstalled()) {
            return new Status(4, "com.aptana.rdt", "RubyGems not installed", null);
        }
        try {
            String command = CLEANUP_COMMAND;
            ILaunchConfiguration config = this.createGemLaunchConfiguration(command, true);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ILaunch launch = config.launch("run", monitor);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    return Status.CANCEL_STATUS;
                }
                Thread.yield();
            }
            this.refresh(monitor);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    @Override
    public IStatus installGem(Gem gem, String sourceURL, IProgressMonitor monitor) {
        return this.installGem(gem, sourceURL, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private IStatus doInstallGem(Gem gem, String command, IProgressMonitor monitor) {
        if (!this.isRubyGemsInstalled()) {
            return new Status(4, "com.aptana.rdt", -1, "RubyGems not installed", null);
        }
        try {
            ILaunchConfiguration config = this.createGemLaunchConfiguration(command, true);
            ILaunch launch = config.launch("run", null);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    try {
                        launch.terminate();
                    }
                    catch (DebugException debugException) {}
                    return Status.CANCEL_STATUS;
                }
                Thread.yield();
            }
            this.refresh(monitor);
            for (GemListener listener : this.listeners) {
                listener.gemAdded(gem);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    private IStatus doLocalInstallGem(Gem gem, IProgressMonitor monitor) {
        if (!this.isRubyGemsInstalled()) {
            return new Status(4, "com.aptana.rdt", -1, "RubyGems not installed", null);
        }
        try {
            String command = "install -l " + new File(gem.getAbsolutePath()).getName();
            ILaunchConfiguration config = this.createGemLaunchConfiguration(command, true);
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, new File(gem.getAbsolutePath()).getParent());
            config = wc.doSave();
            ILaunch launch = config.launch("run", null);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    try {
                        launch.terminate();
                    }
                    catch (DebugException debugException) {}
                    return Status.CANCEL_STATUS;
                }
                Thread.yield();
            }
            this.refresh(monitor);
            for (GemListener listener : new ArrayList(this.listeners)) {
                listener.gemAdded(gem);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    private IStatus installGem(Gem gem, String sourceURL, boolean includeDependencies, IProgressMonitor monitor) {
        String command = "install " + gem.getName();
        if (gem.getVersion() != null && gem.getVersion().trim().length() > 0) {
            command = String.valueOf(command) + " -v " + gem.getVersion();
        }
        if (this.getVersion() == null || this.getVersion().isGreaterThanOrEqualTo("0.9.5")) {
            if (!includeDependencies) {
                command = String.valueOf(command) + " --ignore-dependencies";
            }
        } else if (includeDependencies) {
            command = String.valueOf(command) + " -y";
        }
        if (sourceURL != null && !sourceURL.equals("http://gems.rubyforge.org")) {
            command = String.valueOf(command) + " --source " + sourceURL;
        }
        command = this.addProxy(command);
        return this.doInstallGem(gem, command, monitor);
    }

    private String addProxy(String command) {
        IAptanaProxyService service = this.getProxyService();
        if (service == null || !service.enabled()) {
            return command;
        }
        return String.valueOf(command) + " -p http://" + service.getUsername() + ":" + service.getPassword() + "@" + service.getHostName() + ":" + service.getPort();
    }

    private IAptanaProxyService getProxyService() {
        return new SystemPropertyProxyService();
    }

    @Override
    public Set<GemRequirement> getDependencies(Gem gem) {
        File file;
        if (!this.isRubyGemsInstalled()) {
            return Collections.emptySet();
        }
        String command = "dependency " + gem.getName() + " -v " + gem.getVersion();
        String output = this.launchInBackgroundAndRead(command, file = this.getStateFile("dependencies_" + gem.getName() + "_" + gem.getVersion() + ".txt"));
        Set<GemRequirement> requirements = this.parseDependencies(output);
        if (requirements.isEmpty() && gem.getName().equals("rails")) {
            AptanaRDTPlugin.log("Was unable to find out dependencies for rails gem!");
        }
        return requirements;
    }

    private Set<GemRequirement> parseDependencies(String output) {
        if (output == null) {
            return Collections.emptySet();
        }
        HashSet<GemRequirement> dependencies = new HashSet<GemRequirement>();
        Pattern pat = Pattern.compile("\\s+(\\w+)\\s+\\((.+?)\\)");
        String[] lines = output.split("[\\r|\\n]");
        int i = 1;
        while (i < lines.length) {
            String line = lines[i];
            Matcher matcher = pat.matcher(line);
            if (matcher.find()) {
                String name = matcher.group(1);
                String version = matcher.group(2);
                dependencies.add(new GemRequirement(name, version));
            }
            ++i;
        }
        return dependencies;
    }

    @Override
    public Gem findGem(GemRequirement dependency) {
        for (Gem gem : this.gems) {
            if (gem instanceof LogicalGem) {
                LogicalGem logical = (LogicalGem)gem;
                Collection<Gem> logicalsGems = logical.getGems();
                for (Gem gem2 : logicalsGems) {
                    if (!gem2.meetsRequirements(dependency)) continue;
                    return gem2;
                }
            }
            if (!gem.meetsRequirements(dependency)) continue;
            return gem;
        }
        return null;
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        this.fVersion = null;
        this.fGemInstallPaths = null;
        Job job = new Job("Refreshing local gem listing"){

            protected IStatus run(IProgressMonitor monitor) {
                return GemManager.this.refresh(monitor);
            }
        };
        job.schedule();
    }

    public void vmAdded(IVMInstall newVm) {
    }

    public void vmChanged(PropertyChangeEvent event) {
    }

    public void vmRemoved(IVMInstall removedVm) {
    }

    @Override
    public List<Version> getVersions(String gemName) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (Gem gem : this.gems) {
            if (!gem.getName().equals(gemName)) continue;
            versions.add(gem.getVersionObject());
        }
        return versions;
    }

    @Override
    public String getName() {
        return "Local Gem Manager";
    }

    @Override
    public IStatus updateSystem(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Updating RubyGems", 100);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 33);
        IStatus status = this.installGem(new Gem(RUBYGEMS_UPDATE_GEM_NAME, "", null), (IProgressMonitor)subMonitor);
        subMonitor.done();
        if (!status.isOK()) {
            return status;
        }
        try {
            ILaunchConfiguration config = this.createGemLaunchConfiguration("", true);
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            String fileName = this.getFileIfExists(UPDATE_RUBYGEMS_COMMAND);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, fileName);
            config = wc.doSave();
            ILaunch launch = config.launch("run", monitor);
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    return Status.CANCEL_STATUS;
                }
                Thread.yield();
            }
            monitor.done();
            if (launch.getProcesses() != null && launch.getProcesses()[0] != null && launch.getProcesses()[0].getExitValue() != 0) {
                return new Status(4, "com.aptana.rdt", -1, "Updating rubygems failed", null);
            }
            this.fVersion = null;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private String getFileIfExists(String command) {
        IPath path = RubyRuntime.checkInterpreterBin((String)command);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        path = RubyCore.checkSystemPath((String)command);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        return null;
    }
}

