/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core.builder;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.compiler.BuildContext;
import org.rubypeople.rdt.core.compiler.CompilationParticipant;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemLoadpathAdder
extends CompilationParticipant {
    private IRubyProject project;

    public int aboutToBuild(IRubyProject project) {
        this.project = project;
        return super.aboutToBuild(project);
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        RubyParser parser = new RubyParser();
        HashSet<String> gems = new HashSet<String>();
        int i = 0;
        while (i < files.length) {
            gems.addAll(this.getGemNames(parser, files[i]));
            ++i;
        }
        for (String gemName : gems) {
            if (gemName.equals("rails")) continue;
            try {
                AptanaRDTPlugin.addGemLoadPath(this.project, new Gem(gemName, "", ""), null);
            }
            catch (RubyModelException e) {
                AptanaRDTPlugin.log(e);
            }
        }
    }

    private Collection<String> getGemNames(RubyParser parser, BuildContext context) {
        try {
            char[] contents = context.getContents();
            Node root = parser.parse(new String(contents)).getAST();
            GemVisitor visitor = new GemVisitor();
            root.accept((NodeVisitor)visitor);
            return visitor.getGems();
        }
        catch (SyntaxException syntaxException) {
        }
        catch (Exception e) {
            RubyCore.log((Exception)e);
        }
        return Collections.emptyList();
    }

    public boolean isActive(IRubyProject project) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GemVisitor
    extends InOrderVisitor {
        private Set<String> gems = new HashSet<String>();

        public Instruction visitFCallNode(FCallNode iVisited) {
            List args;
            String name = iVisited.getName();
            if ((name.equals("gem") || name.equals("require_gem")) && (args = ASTUtil.getArgumentsFromFunctionCall((IArgumentNode)iVisited)) != null && !args.isEmpty()) {
                String gemName = (String)args.get(0);
                if (gemName.startsWith("\"") || gemName.startsWith("'")) {
                    gemName = gemName.substring(1, gemName.length() - 1);
                }
                this.gems.add(gemName);
            }
            return super.visitFCallNode(iVisited);
        }

        public Collection<String> getGems() {
            return this.gems;
        }
    }
}

