/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.core.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.rubypeople.rdt.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileGem
extends Gem {
    private URL url;
    private Set<String> dependencies;
    private File file;

    public LocalFileGem(URL url, String name, String version, String description, String platform) {
        super(name, version, description, platform);
        this.url = url;
        this.dependencies = new HashSet<String>();
    }

    public static LocalFileGem create(URL file) {
        String[] fileNameParts = file.getPath().split("[\\|/]");
        String name = fileNameParts[fileNameParts.length - 1];
        String[] parts = name.split("-");
        String version = "";
        String platform = "ruby";
        if (parts != null && parts.length > 1) {
            name = parts[0];
            version = parts[1];
            if (parts.length > 2) {
                platform = parts[2];
            }
        }
        if (version.endsWith(".gem")) {
            version = version.substring(0, version.length() - 4);
        }
        if (platform.endsWith(".gem")) {
            platform = platform.substring(0, platform.length() - 4);
        }
        return new LocalFileGem(file, name, version, "", platform);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public String getAbsolutePath() {
        if (this.file == null) {
            this.file = this.copyFile(this.url);
        }
        return this.file.getAbsolutePath();
    }

    public void addDependency(String name) {
        this.dependencies.add(name);
    }

    @Override
    public void delete() {
        if (this.file == null) {
            return;
        }
        if (!this.file.delete()) {
            this.file.deleteOnExit();
        }
    }

    public Set<String> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    private File copyFile(URL url) {
        byte[] contents = this.getFileContents(url);
        String[] fileNameParts = url.getPath().split("[\\|/]");
        String filename = fileNameParts[fileNameParts.length - 1];
        return this.writeContents(contents, filename);
    }

    private File writeContents(byte[] contents, String filename) {
        File file;
        block14: {
            File tempGemLocation = AptanaRDTPlugin.getDefault().getStateLocation().toFile();
            file = new File(tempGemLocation, filename);
            FileOutputStream outputStream = null;
            try {
                try {
                    outputStream = new FileOutputStream(file);
                    outputStream.write(contents);
                }
                catch (IOException e) {
                    AptanaRDTPlugin.log(e);
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    /*
     * Loose catch block
     */
    private byte[] getFileContents(URL url) {
        InputStream stream = null;
        stream = url.openStream();
        byte[] byArray = Util.getInputStreamAsByteArray((InputStream)stream, (int)-1);
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return byArray;
        catch (IOException e) {
            try {
                AptanaRDTPlugin.log(e);
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new byte[0];
    }
}

