/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.core.gems;

import com.aptana.rdt.core.gems.GemRequirement;
import com.aptana.rdt.core.gems.LogicalGem;
import com.aptana.rdt.core.gems.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gem
implements Comparable {
    private String name;
    private String version;
    private String description;
    private String platform;
    private boolean compiles = false;
    private boolean forceUpdates;
    public static final String RUBY_PLATFORM = "ruby";
    public static final String MSWIN32_PLATFORM = "mswin32";
    public static final String JRUBY_PLATFORM = "java";
    public static final String ANY_VERSION = "";

    public Gem(String name, String version, String description) {
        this(name, version, description, RUBY_PLATFORM);
    }

    public Gem(String name, String version, String description, String platform) {
        if (name == null) {
            throw new IllegalArgumentException("A Gem's name must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("A Gem's version must not be null");
        }
        if (version.indexOf(",") != -1 && !(this instanceof LogicalGem)) {
            throw new IllegalArgumentException("A Gem should have only one version. Use LogicalGem to group multiple versions of same gem.");
        }
        if (platform == null) {
            throw new IllegalArgumentException("A Gem's platform must not be null");
        }
        this.name = name;
        this.version = version;
        this.description = description;
        this.platform = platform;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Version getVersionObject() {
        return new Version(this.version);
    }

    public String getDescription() {
        return this.description;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof Gem)) {
            return false;
        }
        Gem other = (Gem)arg0;
        return this.getName().equals(other.getName()) && this.getVersion().equals(other.getVersion()) && this.getPlatform().equals(other.getPlatform());
    }

    public int hashCode() {
        return this.getName().hashCode() * 100 + this.getVersion().hashCode();
    }

    public int compareTo(Object arg0) {
        if (!(arg0 instanceof Gem)) {
            return -1;
        }
        Gem other = (Gem)arg0;
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        return String.valueOf(this.getName().toLowerCase()) + " " + this.getVersion() + " " + this.getPlatform();
    }

    public boolean hasMultipleVersions() {
        return this.version != null && this.version.indexOf(",") != -1;
    }

    public List<String> versions() {
        ArrayList<String> versions = new ArrayList<String>();
        if (this.version == null) {
            return versions;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.version, ",");
        while (tokenizer.hasMoreTokens()) {
            versions.add(tokenizer.nextToken().trim());
        }
        return versions;
    }

    public String getAbsolutePath() {
        return null;
    }

    public boolean isLocal() {
        return false;
    }

    public void delete() {
    }

    public boolean meetsRequirements(GemRequirement requirement) {
        if (!this.getName().equals(requirement.getName())) {
            return false;
        }
        return requirement.meetsRequirements(this.getVersion());
    }

    public void setCompiles(boolean compiles) {
        this.compiles = compiles;
    }

    public boolean compiles() {
        return this.compiles;
    }

    public boolean forceUpdates() {
        return this.forceUpdates;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdates = forceUpdate;
    }
}

