/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.corext.codemanipulation.StubUtility;
import org.rubypeople.rdt.internal.corext.util.CodeFormatterUtil;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.rubypeople.rdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.SuperModuleSelectionDialog;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.Separator;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.rubypeople.rdt.ui.wizards.NewContainerWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewTypeWizardPage
extends NewContainerWizardPage {
    private static final String PAGE_NAME = "NewTypeWizardPage";
    protected static final String PACKAGE = "NewTypeWizardPage.package";
    protected static final String ENCLOSING = "NewTypeWizardPage.enclosing";
    protected static final String ENCLOSINGSELECTION = "NewTypeWizardPage.enclosing.selection";
    protected static final String TYPENAME = "NewTypeWizardPage.typename";
    protected static final String SUPER = "NewTypeWizardPage.superclass";
    protected static final String INTERFACES = "NewTypeWizardPage.interfaces";
    protected static final String METHODS = "NewTypeWizardPage.methods";
    private IType fCurrType;
    private StringDialogField fTypeNameDialogField;
    private StringButtonDialogField fSuperClassDialogField;
    private ListDialogField fSuperModulesDialogField;
    private IType fCreatedType;
    protected IStatus fTypeNameStatus;
    protected IStatus fSuperClassStatus;
    protected IStatus fSuperModulesStatus;
    private int fTypeKind;
    public static final int CLASS_TYPE = 1;
    public static final int INTERFACE_TYPE = 2;

    public NewTypeWizardPage(boolean isClass, String pageName) {
        this(isClass ? 1 : 2, pageName);
    }

    public NewTypeWizardPage(int typeKind, String pageName) {
        super(pageName);
        this.fTypeKind = typeKind;
        this.fCreatedType = null;
        TypeFieldsAdapter adapter = new TypeFieldsAdapter();
        this.fTypeNameDialogField = new StringDialogField();
        this.fTypeNameDialogField.setDialogFieldListener(adapter);
        this.fTypeNameDialogField.setLabelText(this.getTypeNameLabel());
        this.fSuperClassDialogField = new StringButtonDialogField(adapter);
        this.fSuperClassDialogField.setDialogFieldListener(adapter);
        this.fSuperClassDialogField.setLabelText(this.getSuperClassLabel());
        this.fSuperClassDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_superclass_button);
        String[] stringArray = new String[3];
        stringArray[0] = NewWizardMessages.NewTypeWizardPage_interfaces_add;
        stringArray[2] = NewWizardMessages.NewTypeWizardPage_interfaces_remove;
        String[] addButtons = stringArray;
        this.fSuperModulesDialogField = new ListDialogField(adapter, addButtons, (ILabelProvider)new InterfacesListLabelProvider());
        this.fSuperModulesDialogField.setDialogFieldListener(adapter);
        this.fSuperModulesDialogField.setTableColumns(new ListDialogField.ColumnsDescription(1, false));
        this.fSuperModulesDialogField.setLabelText(this.getSuperModulesLabel());
        this.fSuperModulesDialogField.setRemoveButtonIndex(2);
        this.fTypeNameStatus = new StatusInfo();
        this.fSuperClassStatus = new StatusInfo();
        this.fSuperModulesStatus = new StatusInfo();
    }

    protected String getSourceFolderLabel() {
        return NewWizardMessages.NewTypeWizardPage_package_label;
    }

    protected void createTypeNameControls(Composite composite, int nColumns) {
        this.fTypeNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        Text text = this.fTypeNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        TextFieldNavigationHandler.install(text);
    }

    protected void setFocus() {
        this.fTypeNameDialogField.setFocus();
    }

    public void setTypeName(String name, boolean canBeModified) {
        this.fTypeNameDialogField.setText(name);
        this.fTypeNameDialogField.setEnabled(canBeModified);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected String getSuperModulesLabel() {
        if (this.fTypeKind != 2) {
            return NewWizardMessages.NewTypeWizardPage_interfaces_class_label;
        }
        return NewWizardMessages.NewTypeWizardPage_interfaces_ifc_label;
    }

    protected String getTypeNameLabel() {
        return NewWizardMessages.NewTypeWizardPage_typename_label;
    }

    protected String getSuperClassLabel() {
        return NewWizardMessages.NewTypeWizardPage_superclass_label;
    }

    protected void createSuperClassControls(Composite composite, int nColumns) {
        this.fSuperClassDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fSuperClassDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
    }

    private void typePageLinkActivated(SelectionEvent e) {
        ISourceFolder root = this.getSourceFolder();
        if (root == null) {
            String title = NewWizardMessages.NewTypeWizardPage_configure_templates_title;
            String message = NewWizardMessages.NewTypeWizardPage_configure_templates_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private void typePageChangeControlPressed(DialogField field) {
        IType type;
        if (field == this.fSuperClassDialogField && (type = this.chooseSuperClass()) != null) {
            this.fSuperClassDialogField.setText(type.getElementName());
        }
    }

    private void typePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fSuperModulesDialogField) {
            this.chooseSuperModules();
            List interfaces = this.fSuperModulesDialogField.getElements();
            if (!interfaces.isEmpty()) {
                Object element = interfaces.get(interfaces.size() - 1);
                this.fSuperModulesDialogField.editElement(element);
            }
        }
    }

    public void setSuperClass(String name, boolean canBeModified) {
        this.fSuperClassDialogField.setText(name);
        this.fSuperClassDialogField.setEnabled(canBeModified);
    }

    protected void createTypeMembers(IType newType, IProgressMonitor monitor) throws CoreException {
    }

    protected String getRubyScriptName(String typeName) {
        int index = typeName.lastIndexOf("::");
        if (index != -1) {
            typeName = typeName.substring(index + 2);
        }
        return String.valueOf(Util.camelCaseToUnderscores((String)typeName)) + ".rb";
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.NewTypeWizardPage_operationdesc, 8);
        ISourceFolder pack = this.getSourceFolder();
        monitor.worked(1);
        IRubyScript connectedCU = null;
        try {
            String typeName = this.getTypeName();
            int indent = 0;
            String lineDelimiter = StubUtility.getLineDelimiterUsed(pack.getRubyProject());
            String cuName = this.getRubyScriptName(typeName);
            IRubyScript parentCU = pack.createRubyScript(cuName, "", false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            boolean needsSave = true;
            parentCU.becomeWorkingCopy(null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            connectedCU = parentCU;
            IBuffer buffer = parentCU.getBuffer();
            String cuContent = this.constructSimpleTypeStub(lineDelimiter);
            buffer.setContents(cuContent);
            IType createdType = parentCU.getType(typeName);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            IRubyScript cu = createdType.getRubyScript();
            RubyModelUtil.reconcile(cu);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.createTypeMembers(createdType, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            RubyModelUtil.reconcile(cu);
            ISourceRange range = createdType.getSourceRange();
            int length = range.getLength() + 1;
            if (lineDelimiter.length() > 1) {
                ++length;
            }
            IBuffer buf = cu.getBuffer();
            String originalContent = buf.getText(range.getOffset(), length);
            String formattedContent = CodeFormatterUtil.format(4, originalContent, indent, null, lineDelimiter, pack.getRubyProject());
            buf.replace(range.getOffset(), length, formattedContent);
            this.fCreatedType = createdType;
            if (needsSave) {
                cu.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
        }
        finally {
            if (connectedCU != null) {
                connectedCU.discardWorkingCopy();
            }
            monitor.done();
        }
    }

    private String constructSimpleTypeStub(String lineDelimiter) {
        StringBuffer buf = new StringBuffer();
        List<String> imports = this.addImports();
        if (imports != null) {
            for (String string : imports) {
                buf.append("require \"");
                buf.append(string);
                buf.append('\"');
                buf.append(lineDelimiter);
            }
        }
        buf.append("class ");
        buf.append(this.getTypeName());
        String superclass = this.getSuperClass();
        if (superclass != null && superclass.trim().length() > 0 && !superclass.trim().equals("Object")) {
            buf.append(" < ");
            buf.append(superclass.trim());
        }
        buf.append(lineDelimiter);
        buf.append("end");
        return buf.toString();
    }

    protected List<String> addImports() {
        return null;
    }

    protected void chooseSuperModules() {
        ISourceFolder root = this.getSourceFolder();
        if (root == null) {
            return;
        }
        IRubyProject project = root.getRubyProject();
        SuperModuleSelectionDialog dialog = new SuperModuleSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this, project);
        dialog.setTitle(this.getModuleDialogTitle());
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_InterfacesDialog_message);
        dialog.open();
    }

    public void setSuperModules(List interfacesNames, boolean canBeModified) {
        ArrayList<InterfaceWrapper> interfaces = new ArrayList<InterfaceWrapper>(interfacesNames.size());
        Iterator iter = interfacesNames.iterator();
        while (iter.hasNext()) {
            interfaces.add(new InterfaceWrapper((String)iter.next()));
        }
        this.fSuperModulesDialogField.setElements(interfaces);
        this.fSuperModulesDialogField.setEnabled(canBeModified);
    }

    public List getSuperModules() {
        List interfaces = this.fSuperModulesDialogField.getElements();
        ArrayList<String> result = new ArrayList<String>(interfaces.size());
        for (InterfaceWrapper wrapper : interfaces) {
            result.add(wrapper.interfaceName);
        }
        return result;
    }

    public boolean addSuperModule(String superInterface) {
        return this.fSuperModulesDialogField.addElement(new InterfaceWrapper(superInterface));
    }

    private String getModuleDialogTitle() {
        if (this.fTypeKind == 2) {
            return NewWizardMessages.NewTypeWizardPage_InterfacesDialog_interface_title;
        }
        return NewWizardMessages.NewTypeWizardPage_InterfacesDialog_class_title;
    }

    public IResource getModifiedResource() {
        ISourceFolder pack = this.getSourceFolder();
        if (pack != null) {
            String cuName = this.getRubyScriptName(this.getTypeName());
            return pack.getRubyScript(cuName).getResource();
        }
        return null;
    }

    private void typePageDialogFieldChanged(DialogField field) {
        String fieldName = null;
        if (field == this.fTypeNameDialogField) {
            this.fTypeNameStatus = this.typeNameChanged();
            fieldName = TYPENAME;
        } else if (field == this.fSuperClassDialogField) {
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = SUPER;
        } else if (field == this.fSuperModulesDialogField) {
            this.fSuperModulesStatus = this.superInterfacesChanged();
            fieldName = INTERFACES;
        } else {
            fieldName = METHODS;
        }
        this.handleFieldChanged(fieldName);
    }

    public String getSuperClass() {
        return this.fSuperClassDialogField.getText();
    }

    protected IStatus superClassChanged() {
        StatusInfo status = new StatusInfo();
        ISourceFolder root = this.getSourceFolder();
        this.fSuperClassDialogField.enableButton(root != null);
        String sclassName = this.getSuperClass();
        if (sclassName.length() == 0) {
            return status;
        }
        if (root == null) {
            status.setError("");
        }
        return status;
    }

    public String getTypeName() {
        return this.fTypeNameDialogField.getText();
    }

    private IStatus typeNameChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrType = null;
        String typeName = this.getTypeName();
        if (typeName.length() == 0) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnterTypeName);
            return status;
        }
        if (!this.isConstant(typeName)) {
            status.setError("Class name must be a constant. It must begin with a capital letter, and contain only letters, digits, or underscores.");
            return status;
        }
        return status;
    }

    protected void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fTypeNameStatus, this.fSuperClassStatus, this.fSuperModulesStatus};
        this.updateStatus(status);
    }

    @Override
    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            this.fSuperModulesStatus = this.superInterfacesChanged();
        }
        this.doStatusUpdate();
    }

    protected void initTypePage(IRubyElement elem) {
        String text;
        String initSuperclass = "Object";
        ArrayList initSuperinterfaces = new ArrayList(5);
        ISourceFolder folder = this.getSourceFolder();
        IType enclosingType = null;
        if (elem != null) {
            elem.getRubyProject();
            IType typeInCU = (IType)elem.getAncestor(5);
            if (typeInCU != null) {
                if (typeInCU.getRubyScript() != null) {
                    enclosingType = typeInCU;
                }
            } else {
                IRubyScript cu = (IRubyScript)elem.getAncestor(4);
                if (cu != null) {
                    enclosingType = cu.findPrimaryType();
                }
            }
        }
        String typeName = "";
        ITextSelection selection = this.getCurrentTextSelection();
        if (selection != null && (text = selection.getText()) != null && RubyConventions.validateRubyTypeName((String)text).isOK()) {
            typeName = text;
        }
        if (enclosingType != null) {
            typeName = enclosingType.getElementName();
            try {
                initSuperclass = enclosingType.getSuperclassName();
                initSuperinterfaces.addAll(Arrays.asList(enclosingType.getIncludedModuleNames()));
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
        }
        this.setSourceFolder(folder, true);
        this.setTypeName(typeName, true);
        this.setSuperClass(initSuperclass, true);
    }

    private boolean isConstant(String className) {
        if (className == null || className.length() == 0) {
            return false;
        }
        int namespaceDelimeterIndex = className.indexOf("::");
        if (namespaceDelimeterIndex != -1) {
            return this.isConstant(className.substring(0, namespaceDelimeterIndex)) && this.isConstant(className.substring(namespaceDelimeterIndex + 2));
        }
        return className.matches("^[A-Z]\\w*");
    }

    protected IStatus superInterfacesChanged() {
        StatusInfo status = new StatusInfo();
        ISourceFolder root = this.getSourceFolder();
        this.fSuperModulesDialogField.enableButton(0, root != null);
        if (root != null) {
            List elements = this.fSuperModulesDialogField.getElements();
            int nElements = elements.size();
            int i = 0;
            while (i < nElements) {
                ++i;
            }
        }
        return status;
    }

    protected IType chooseSuperClass() {
        ISourceFolder root = this.getSourceFolder();
        if (root == null) {
            return null;
        }
        IRubyElement[] elements = new IRubyElement[]{root.getRubyProject()};
        IRubySearchScope scope = SearchEngine.createRubySearchScope((IRubyElement[])elements);
        TypeSelectionDialog2 dialog = new TypeSelectionDialog2(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 4);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_SuperClassDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_SuperClassDialog_message);
        dialog.setFilter(this.getSuperClass());
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    private static class InterfaceWrapper {
        public String interfaceName;

        public InterfaceWrapper(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public int hashCode() {
            return this.interfaceName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && ((InterfaceWrapper)obj).interfaceName.equals(this.interfaceName);
        }
    }

    private static class InterfacesListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = RubyPluginImages.get("org.rubypeople.rdt.ui.module_obj.gif");

        public String getText(Object element) {
            return ((InterfaceWrapper)element).interfaceName;
        }

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }

    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter,
    SelectionListener {
        private TypeFieldsAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewTypeWizardPage.this.typePageChangeControlPressed(field);
        }

        public void customButtonPressed(ListDialogField field, int index) {
            NewTypeWizardPage.this.typePageCustomButtonPressed(field, index);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            NewTypeWizardPage.this.typePageDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
        }

        public void widgetSelected(SelectionEvent e) {
            NewTypeWizardPage.this.typePageLinkActivated(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            NewTypeWizardPage.this.typePageLinkActivated(e);
        }
    }
}

