/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.codemanipulation.StubUtility;
import org.rubypeople.rdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.Separator;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.rubypeople.rdt.ui.wizards.NewContainerWizardPage;

public class NewFileWizardPage
extends NewContainerWizardPage {
    private StringDialogField fScriptNameDialogField;
    private IRubyScript fCreatedScript;
    private static final String PAGE_NAME = "NewFileWizardPage";

    public NewFileWizardPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewFileWizardPage_title);
        this.setDescription(NewWizardMessages.NewFileWizardPage_description);
        this.fScriptNameDialogField = new StringDialogField();
        this.fScriptNameDialogField.setLabelText(this.getScriptNameLabel());
        this.fScriptNameDialogField.setText(this.getDefaultScriptName());
    }

    private String getDefaultScriptName() {
        return "file.rb";
    }

    protected String getScriptNameLabel() {
        return NewWizardMessages.NewFileWizardPage_scriptname_label;
    }

    public void createScript(IProgressMonitor monitor) throws RubyModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.NewTypeWizardPage_operationdesc, 8);
        ISourceFolder pack = this.getSourceFolder();
        monitor.worked(1);
        try {
            String lineDelimiter = StubUtility.getLineDelimiterUsed(pack.getRubyProject());
            String cuName = this.getRubyScriptName();
            String contents = "if __FILE__ == $0" + lineDelimiter + "  # TODO Generated stub" + lineDelimiter + "end";
            this.fCreatedScript = pack.createRubyScript(cuName, contents, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    public IResource getModifiedResource() {
        ISourceFolder pack = this.getSourceFolder();
        if (pack != null) {
            String cuName = this.getRubyScriptName();
            return pack.getRubyScript(cuName).getResource();
        }
        return null;
    }

    public String getRubyScriptName() {
        return this.fScriptNameDialogField.getText();
    }

    public IRubyElement getCreatedScript() {
        return this.fCreatedScript;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createScriptNameControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createScriptNameControls(Composite composite, int nColumns) {
        this.fScriptNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        Text text = this.fScriptNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        TextFieldNavigationHandler.install(text);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    public void init(IStructuredSelection selection) {
        IRubyElement jelem = this.getInitialRubyElement(selection);
        this.initContainerPage(jelem);
    }
}

