/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.rubypeople.rdt.ui.wizards.NewTypeWizardPage;

public class NewClassWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private static final String SETTINGS_CREATECONSTR = "create_constructor";
    private SelectionButtonDialogFieldGroup fMethodStubsButtons;

    public NewClassWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(NewWizardMessages.NewClassWizardPage_title);
        this.setDescription(NewWizardMessages.NewClassWizardPage_description);
        String[] buttonNames3 = new String[]{NewWizardMessages.NewClassWizardPage_methods_constructors};
        this.fMethodStubsButtons = new SelectionButtonDialogFieldGroup(32, buttonNames3, 1);
        this.fMethodStubsButtons.setLabelText(NewWizardMessages.NewClassWizardPage_methods_label);
    }

    public void init(IStructuredSelection selection) {
        IDialogSettings section;
        IRubyElement jelem = this.getInitialRubyElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
        boolean createConstructors = false;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (section = dialogSettings.getSection(PAGE_NAME)) != null) {
            createConstructors = section.getBoolean(SETTINGS_CREATECONSTR);
        }
        this.setMethodStubSelection(createConstructors, true);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.rubypeople.rdt.ui.new_class_wizard_page_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        } else {
            IDialogSettings dialogSettings = this.getDialogSettings();
            if (dialogSettings != null) {
                IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
                if (section == null) {
                    section = dialogSettings.addNewSection(PAGE_NAME);
                }
                section.put(SETTINGS_CREATECONSTR, this.isCreateConstructors());
            }
        }
    }

    private void createMethodStubSelectionControls(Composite composite, int nColumns) {
        Label labelControl = this.fMethodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, nColumns);
        DialogField.createEmptySpace(composite);
        Composite buttonGroup = this.fMethodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, nColumns - 1);
    }

    public boolean isCreateConstructors() {
        return this.fMethodStubsButtons.isSelected(0);
    }

    public void setMethodStubSelection(boolean createConstructors, boolean canBeModified) {
        this.fMethodStubsButtons.setSelection(0, createConstructors);
        this.fMethodStubsButtons.setEnabled(canBeModified);
    }

    protected void createTypeMembers(IType type, IProgressMonitor monitor) throws CoreException {
        boolean doConstr = this.isCreateConstructors();
        if (doConstr) {
            StringBuffer buf = new StringBuffer();
            buf.append("def initialize");
            buf.append("\n");
            buf.append("super");
            buf.append("\n");
            buf.append("end");
            buf.append("\n");
            type.createMethod(buf.toString(), null, false, null);
        }
        if (monitor != null) {
            monitor.done();
        }
    }
}

