/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.text.ruby;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.rubypeople.rdt.core.CompletionProposal;
import org.rubypeople.rdt.core.CompletionRequestor;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.compiler.IProblem;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.ruby.CompletionProposalLabelProvider;
import org.rubypeople.rdt.internal.ui.text.ruby.FillArgsAndBlockProposal;
import org.rubypeople.rdt.internal.ui.text.ruby.FillMethodArgumentsProposal;
import org.rubypeople.rdt.internal.ui.text.ruby.ProposalInfo;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCompletionProposal;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyContentAssistInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;

public class CompletionProposalCollector
extends CompletionRequestor {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.rubypeople.rdt.ui/debug/ResultCollector"));
    private final CompletionProposalLabelProvider fLabelProvider = new CompletionProposalLabelProvider();
    private final ImageDescriptorRegistry fRegistry = RubyPlugin.getImageDescriptorRegistry();
    protected static final char[] VAR_TRIGGER = new char[]{'\t', ' ', '=', ';', '.'};
    private final List fRubyProposals = new ArrayList();
    private final List fKeywords = new ArrayList();
    private final Set fSuggestedMethodNames = new HashSet();
    private final IRubyScript fRubyScript;
    private final IRubyProject fRubyProject;
    private int fUserReplacementLength;
    private IProblem fLastProblem;
    private long fStartTime;
    private long fUITime;
    private RubyContentAssistInvocationContext context;

    public CompletionProposalCollector(RubyContentAssistInvocationContext context) {
        this(context.getProject(), context.getRubyScript());
        this.context = context;
    }

    private CompletionProposalCollector(IRubyProject project, IRubyScript cu) {
        this.fRubyProject = project;
        this.fRubyScript = cu;
        this.fUserReplacementLength = -1;
    }

    public final IRubyCompletionProposal[] getRubyCompletionProposals() {
        return this.fRubyProposals.toArray(new IRubyCompletionProposal[this.fRubyProposals.size()]);
    }

    public final IRubyCompletionProposal[] getKeywordCompletionProposals() {
        return this.fKeywords.toArray(new RubyCompletionProposal[this.fKeywords.size()]);
    }

    public void accept(CompletionProposal proposal) {
        if (proposal == null) {
            return;
        }
        long start = DEBUG ? System.currentTimeMillis() : 0L;
        try {
            IRubyCompletionProposal rubyProposal;
            if (this.isFiltered(proposal)) {
                return;
            }
            if (proposal.getKind() != 11 && (rubyProposal = this.createRubyCompletionProposal(proposal)) != null) {
                this.fRubyProposals.add(rubyProposal);
                if (proposal.getKind() == 3) {
                    this.fKeywords.add(rubyProposal);
                }
            }
        }
        catch (IllegalArgumentException e) {
            RubyPlugin.log((IStatus)new Status(4, RubyPlugin.getPluginId(), 0, "Exception when processing proposal for: " + String.valueOf(proposal.getCompletion()), (Throwable)e));
        }
        if (DEBUG) {
            this.fUITime += System.currentTimeMillis() - start;
        }
    }

    protected int computeRelevance(CompletionProposal proposal) {
        int baseRelevance = proposal.getRelevance() * 16;
        switch (proposal.getKind()) {
            case 3: {
                return baseRelevance + 2;
            }
            case 9: {
                return baseRelevance + 3;
            }
            case 6: 
            case 7: 
            case 12: {
                return baseRelevance + 4;
            }
            case 11: {
                return baseRelevance + 4;
            }
            case 2: 
            case 4: 
            case 8: {
                return baseRelevance + 5;
            }
            case 5: 
            case 10: {
                return baseRelevance + 6;
            }
        }
        return baseRelevance;
    }

    protected boolean isFiltered(CompletionProposal proposal) {
        return this.isIgnored(proposal.getKind());
    }

    protected IRubyCompletionProposal createRubyCompletionProposal(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 6: {
                IRubyCompletionProposal proposal2 = this.createMethodReferenceProposal(proposal);
                if (this.fSuggestedMethodNames.contains(proposal2.getDisplayString())) {
                    return null;
                }
                this.fSuggestedMethodNames.add(proposal2.getDisplayString());
                return proposal2;
            }
        }
        return this.createProposal(proposal);
    }

    private IRubyCompletionProposal createMethodReferenceProposal(CompletionProposal methodProposal) {
        boolean fillArgs = RubyPlugin.getDefault().getPreferenceStore().getBoolean("content_assist_fill_method_arguments");
        if (fillArgs) {
            boolean fillBlockArgs = RubyPlugin.getDefault().getPreferenceStore().getBoolean("content_assist_fill_method_block_arguments");
            String completion = String.valueOf(methodProposal.getCompletion());
            if (completion.length() == 0 || completion.length() == 1 && completion.charAt(0) == ')' || methodProposal.getParameterNames() == null || methodProposal.getParameterNames().length == 0) {
                return this.createProposal(methodProposal);
            }
            if (fillBlockArgs) {
                return new FillArgsAndBlockProposal(methodProposal, this.context);
            }
            return new FillMethodArgumentsProposal(methodProposal, this.context);
        }
        return this.createProposal(methodProposal);
    }

    protected final IRubyScript getRubyScript() {
        return this.fRubyScript;
    }

    protected final Image getImage(ImageDescriptor descriptor) {
        return descriptor == null ? null : this.fRegistry.get(descriptor);
    }

    private IRubyCompletionProposal createProposal(CompletionProposal proposal) {
        String completion = proposal.getCompletion();
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.fLabelProvider.createLabel(proposal);
        int relevance = this.computeRelevance(proposal);
        Image image = this.getImage(this.fLabelProvider.createImageDescriptor(proposal));
        RubyCompletionProposal rubyProposal = new RubyCompletionProposal(completion, start, length, image, label, relevance);
        if (proposal.getElement() != null && proposal.getElement() instanceof IMember) {
            ProposalInfo info = new ProposalInfo((IMember)proposal.getElement());
            rubyProposal.setProposalInfo(info);
        }
        return rubyProposal;
    }

    protected final int getLength(CompletionProposal proposal) {
        int length;
        int start = proposal.getReplaceStart();
        int end = proposal.getReplaceEnd();
        if (this.fUserReplacementLength == -1) {
            length = end - start;
        } else {
            length = this.fUserReplacementLength;
            int behindCompletion = proposal.getCompletionLocation() + 1;
            if (start < behindCompletion) {
                length += behindCompletion - start;
            }
        }
        return length;
    }

    public void beginReporting() {
        if (DEBUG) {
            this.fStartTime = System.currentTimeMillis();
            this.fUITime = 0L;
        }
        this.fLastProblem = null;
        this.fRubyProposals.clear();
        this.fKeywords.clear();
        this.fSuggestedMethodNames.clear();
    }

    public void completionFailure(IProblem problem) {
        this.fLastProblem = problem;
    }

    public void endReporting() {
        if (DEBUG) {
            long total = System.currentTimeMillis() - this.fStartTime;
            System.err.println("Core Collector (core):\t" + (total - this.fUITime));
            System.err.println("Core Collector (ui):\t" + this.fUITime);
        }
        this.fSuggestedMethodNames.clear();
    }

    public String getErrorMessage() {
        if (this.fLastProblem != null) {
            return this.fLastProblem.getMessage();
        }
        return "";
    }
}

