/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.correction.CorrectionCommandHandler;
import org.rubypeople.rdt.internal.ui.text.correction.CorrectionMessages;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.text.correction.ICommandAccess;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

public class ChangeCorrectionProposal
implements IRubyCompletionProposal,
ICommandAccess {
    private Change fChange;
    private String fName;
    private int fRelevance;
    private Image fImage;
    private String fCommandId;

    public ChangeCorrectionProposal(String name, Change change, int relevance, Image image) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
        this.fChange = change;
        this.fRelevance = relevance;
        this.fImage = image;
        this.fCommandId = null;
    }

    public void apply(IDocument document) {
        try {
            this.performChange(RubyPlugin.getActivePage().getActiveEditor(), document);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, CorrectionMessages.ChangeCorrectionProposal_error_title, CorrectionMessages.ChangeCorrectionProposal_error_message);
        }
    }

    protected void performChange(IEditorPart activeEditor, IDocument document) throws CoreException {
        Change change = null;
        IRewriteTarget rewriteTarget = null;
        try {
            change = this.getChange();
            if (change != null) {
                if (document != null) {
                    LinkedModeModel.closeAllModels((IDocument)document);
                }
                if (activeEditor != null && (rewriteTarget = (IRewriteTarget)activeEditor.getAdapter(IRewriteTarget.class)) != null) {
                    rewriteTarget.beginCompoundChange();
                }
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = change.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, RubyPlugin.getPluginId(), 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException((IStatus)status);
                }
                change.perform((IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            if (rewriteTarget != null) {
                rewriteTarget.endCompoundChange();
            }
            if (change != null) {
                change.dispose();
            }
        }
    }

    public String getAdditionalProposalInfo() {
        StringBuffer buf;
        block3: {
            String name;
            block4: {
                buf = new StringBuffer();
                buf.append("<p>");
                Change change = this.getChange();
                if (change == null) break block3;
                name = change.getName();
                if (name.length() != 0) break block4;
                return null;
            }
            try {
                buf.append(name);
            }
            catch (CoreException e) {
                buf.append("Unexpected error when accessing this proposal:<p><pre>");
                buf.append(e.getLocalizedMessage());
                buf.append("</pre>");
            }
        }
        return null;
        buf.append("</p>");
        return buf.toString();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            return Messages.format((String)CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, (Object[])new String[]{this.fName, shortCutString});
        }
        return this.fName;
    }

    public Image getImage() {
        return this.fImage;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public final Change getChange() throws CoreException {
        if (this.fChange == null) {
            this.fChange = this.createChange();
        }
        return this.fChange;
    }

    protected Change createChange() throws CoreException {
        return new NullChange();
    }

    public void setDisplayName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public String getCommandId() {
        return this.fCommandId;
    }

    public void setCommandId(String commandId) {
        this.fCommandId = commandId;
    }
}

