/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.formatter.Indents;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;

public class SurroundWithBeginRescueAction
extends SelectionDispatchAction {
    public static final String SURROUND_WTH_BEGIN_RESCUE = "SurroundWithBeginRescue";
    private RubyEditor fEditor;

    public SurroundWithBeginRescueAction(RubyEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(ActionMessages.SurroundWithBeginRescueAction_label);
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && SelectionConverter.getInputAsRubyScript(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.surround_with_try_catch_action");
    }

    public void run(ITextSelection selection) {
        try {
            this.createChange(selection, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, SurroundWithBeginRescueAction.getDialogTitle(), ActionMessages.SurroundWithBeginRescueAction_error);
        }
    }

    private static String getDialogTitle() {
        return ActionMessages.SurroundWithBeginRescueAction_dialog_title;
    }

    private IFile getFile() {
        IRubyScript cu = this.getRubyScript();
        return (IFile)RubyModelUtil.toOriginal(cu).getResource();
    }

    private IRubyScript getRubyScript() {
        return SelectionConverter.getInputAsRubyScript(this.fEditor);
    }

    public void createChange(ITextSelection selection, IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 2);
        IPath path = this.getFile().getFullPath();
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        try {
            try {
                bufferManager.connect(path, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                IDocument document = bufferManager.getTextFileBuffer(path).getDocument();
                String text = this.createBeginRescueBlock(document, selection);
                document.replace(selection.getOffset(), selection.getLength(), text);
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, RubyPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
            }
        }
        finally {
            bufferManager.disconnect(path, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            pm.done();
        }
    }

    private String createBeginRescueBlock(IDocument document, ITextSelection selection) throws BadLocationException, RubyModelException {
        String originalText = selection.getText();
        String lineDelimiter = document.getLineDelimiter(0);
        Map options = this.getRubyScript().getRubyProject().getOptions(true);
        int lineNumber = selection.getStartLine();
        String line = document.get(document.getLineOffset(lineNumber), document.getLineLength(lineNumber));
        int indentationUnits = Indents.measureIndentUnits((CharSequence)line, (int)Indents.getTabWidth((Map)options), (int)Indents.getIndentWidth((Map)options));
        StringBuffer text = new StringBuffer();
        text.append("begin");
        text.append(lineDelimiter);
        text.append(Indents.createIndentString((int)(indentationUnits + 1), (Map)options));
        text.append(originalText);
        text.append(lineDelimiter);
        text.append(Indents.createIndentString((int)indentationUnits, (Map)options));
        text.append("rescue StandardError => e");
        text.append(lineDelimiter);
        text.append(Indents.createIndentString((int)(indentationUnits + 1), (Map)options));
        text.append("puts e");
        text.append(lineDelimiter);
        text.append(Indents.createIndentString((int)indentationUnits, (Map)options));
        text.append("end");
        text.append(lineDelimiter);
        text.append(Indents.createIndentString((int)indentationUnits, (Map)options));
        return text.toString();
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(selection.getLength() > 0 && this.fEditor != null && SelectionConverter.getInputAsRubyScript(this.fEditor) != null);
    }
}

