/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.IUpdate;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;

public class RubyActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.rubypeople.rdt.ui.source.menu";
    public static final String GROUP_GENERATE = "generateGroup";
    public static final String GROUP_CODE = "codeGroup";
    private static final String GROUP_COMMENT = "commentGroup";
    public static final String GROUP_EDIT = "editGroup";
    private RubyEditor fEditor;
    private String fGroupName;

    public RubyActionGroup(RubyEditor editor, String groupName) {
        this.fEditor = editor;
        this.fGroupName = groupName;
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        String menuText = "Source";
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        int added = 0;
        added = this.isEditorOwner() ? this.fillEditorSubMenu((IMenuManager)subMenu) : this.fillViewSubMenu((IMenuManager)subMenu);
        if (added > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    private int fillEditorSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        added += this.addEditorAction(source, "ToggleComment");
        added += this.addEditorAction(source, "AddBlockComment");
        added += this.addEditorAction(source, "RemoveBlockComment");
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        added += this.addEditorAction(source, "Indent");
        added += this.addEditorAction(source, "Format");
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        source.add((IContributionItem)new Separator(GROUP_CODE));
        return added += this.addEditorAction(source, "SurroundWithBeginRescue");
    }

    private int fillViewSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        source.add((IContributionItem)new Separator(GROUP_CODE));
        return added;
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }
}

