/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.actions.ActionUtil;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction {
    private RubyEditor fEditor;

    public OpenTypeHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenTypeHierarchyAction_label);
        this.setToolTipText(ActionMessages.OpenTypeHierarchyAction_tooltip);
        this.setDescription(ActionMessages.OpenTypeHierarchyAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.open_type_hierarchy_action");
    }

    public OpenTypeHierarchyAction(IWorkbenchSite site, ISelectionProvider provider) {
        this(site);
        this.setSpecialSelectionProvider(provider);
    }

    public OpenTypeHierarchyAction(RubyEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn((IEditorPart)this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IRubyElement)) {
            return false;
        }
        switch (((IRubyElement)input).getElementType()) {
            case 5: 
            case 6: 
            case 15: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public void run(ITextSelection selection) {
        IRubyElement input = SelectionConverter.getInput((IEditorPart)this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        try {
            IRubyElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null) {
                return;
            }
            ArrayList candidates = new ArrayList(elements.length);
            int i = 0;
            while (i < elements.length) {
                IRubyElement[] resolvedElements = OpenTypeHierarchyUtil.getCandidates(elements[i]);
                if (resolvedElements != null) {
                    candidates.addAll(Arrays.asList(resolvedElements));
                }
                ++i;
            }
            this.run(candidates.toArray(new IRubyElement[candidates.size()]));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), OpenTypeHierarchyAction.getDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IRubyElement)) {
            IStatus status = OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_ruby_element);
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.OpenTypeHierarchyAction_messages_title, (IStatus)status);
            return;
        }
        IRubyElement element = (IRubyElement)input;
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        ArrayList result = new ArrayList(1);
        IStatus status = OpenTypeHierarchyAction.compileCandidates(result, element);
        if (status.isOK()) {
            this.run(result.toArray(new IRubyElement[result.size()]));
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.OpenTypeHierarchyAction_messages_title, (IStatus)status);
        }
    }

    public void run(IRubyElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        OpenTypeHierarchyUtil.open(elements, this.getSite().getWorkbenchWindow());
    }

    private static String getDialogTitle() {
        return ActionMessages.OpenTypeHierarchyAction_dialog_title;
    }

    private static IStatus compileCandidates(List result, IRubyElement elem) {
        Status ok = new Status(0, RubyPlugin.getPluginId(), 0, "", null);
        try {
            switch (elem.getElementType()) {
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 15: {
                    result.add(elem);
                    return ok;
                }
                case 3: {
                    if (((ISourceFolder)elem).containsRubyResources()) {
                        result.add(elem);
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_ruby_resources);
                }
                case 8: {
                    IImportDeclaration cfr_ignored_0 = (IImportDeclaration)elem;
                    elem = elem.getRubyProject().findType(elem.getElementName());
                    if (elem != null) {
                        result.add(elem);
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_unknown_import_decl);
                }
                case 4: {
                    IRubyScript cu = (IRubyScript)elem;
                    IType[] types = cu.getTypes();
                    if (types.length > 0) {
                        result.addAll((Collection)Arrays.asList(types));
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_types);
                }
            }
        }
        catch (RubyModelException e) {
            return e.getStatus();
        }
        return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_valid_ruby_element);
    }

    private static IStatus createStatus(String message) {
        return new Status(1, RubyPlugin.getPluginId(), 10001, message, null);
    }
}

