/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.actions.ActionUtil;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;

public class OpenCallHierarchyAction
extends SelectionDispatchAction {
    private RubyEditor fEditor;

    public OpenCallHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(CallHierarchyMessages.OpenCallHierarchyAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenCallHierarchyAction_tooltip);
        this.setDescription(CallHierarchyMessages.OpenCallHierarchyAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.call_hierarchy_open_action_context");
    }

    public OpenCallHierarchyAction(IWorkbenchSite site, ISelectionProvider provider) {
        this(site);
        this.setSpecialSelectionProvider(provider);
    }

    public OpenCallHierarchyAction(RubyEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn((IEditorPart)this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IRubyElement)) {
            return false;
        }
        switch (((IRubyElement)input).getElementType()) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void run(ITextSelection selection) {
        IRubyElement input = SelectionConverter.getInput((IEditorPart)this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        try {
            IRubyElement enclosingMethod;
            IRubyElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null) {
                return;
            }
            ArrayList<IRubyElement> candidates = new ArrayList<IRubyElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                IRubyElement[] resolvedElements = CallHierarchyUI.getCandidates(elements[i]);
                if (resolvedElements != null) {
                    candidates.addAll((Collection)Arrays.asList(resolvedElements));
                }
                ++i;
            }
            if (candidates.isEmpty() && (enclosingMethod = this.getEnclosingMethod(input, selection)) != null) {
                candidates.add(enclosingMethod);
            }
            this.run(candidates.toArray(new IRubyElement[candidates.size()]));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), OpenCallHierarchyAction.getErrorDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IRubyElement getEnclosingMethod(IRubyElement input, ITextSelection selection) {
        IRubyElement enclosingElement = null;
        try {
            switch (input.getElementType()) {
                case 4: {
                    IRubyScript cu = (IRubyScript)input.getAncestor(4);
                    if (cu == null) break;
                    enclosingElement = cu.getElementAt(selection.getOffset());
                }
            }
            if (enclosingElement != null && enclosingElement.getElementType() == 6) {
                return enclosingElement;
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IRubyElement)) {
            IStatus status = OpenCallHierarchyAction.createStatus(CallHierarchyMessages.OpenCallHierarchyAction_messages_no_java_element);
            this.openErrorDialog(status);
            return;
        }
        IRubyElement element = (IRubyElement)input;
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        ArrayList result = new ArrayList(1);
        IStatus status = OpenCallHierarchyAction.compileCandidates(result, element);
        if (status.isOK()) {
            this.run(result.toArray(new IRubyElement[result.size()]));
        } else {
            this.openErrorDialog(status);
        }
    }

    private int openErrorDialog(IStatus status) {
        String message = CallHierarchyMessages.OpenCallHierarchyAction_messages_title;
        String dialogTitle = OpenCallHierarchyAction.getErrorDialogTitle();
        return ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)message, (IStatus)status);
    }

    private static String getErrorDialogTitle() {
        return CallHierarchyMessages.OpenCallHierarchyAction_dialog_title;
    }

    public void run(IRubyElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        CallHierarchyUI.open(elements, this.getSite().getWorkbenchWindow());
    }

    private static IStatus compileCandidates(List result, IRubyElement elem) {
        Status ok = new Status(0, RubyPlugin.getPluginId(), 0, "", null);
        switch (elem.getElementType()) {
            case 6: {
                result.add(elem);
                return ok;
            }
        }
        return OpenCallHierarchyAction.createStatus(CallHierarchyMessages.OpenCallHierarchyAction_messages_no_valid_java_element);
    }

    private static IStatus createStatus(String message) {
        return new Status(1, RubyPlugin.getPluginId(), 10001, message, null);
    }
}

