/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.ILocalVariable;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.search.RubySearchScopeFactory;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.ui.actions.FindReferencesAction;
import org.rubypeople.rdt.ui.search.ElementQuerySpecification;
import org.rubypeople.rdt.ui.search.QuerySpecification;

public class FindReferencesInHierarchyAction
extends FindReferencesAction {
    public FindReferencesInHierarchyAction(IWorkbenchSite site) {
        super(site);
    }

    public FindReferencesInHierarchyAction(RubyEditor editor) {
        super(editor);
    }

    Class[] getValidTypes() {
        return new Class[]{IRubyScript.class, IType.class, IMethod.class, IField.class, ILocalVariable.class};
    }

    void init() {
        this.setText(SearchMessages.Search_FindHierarchyReferencesAction_label);
        this.setToolTipText(SearchMessages.Search_FindHierarchyReferencesAction_tooltip);
        this.setImageDescriptor(RubyPluginImages.DESC_OBJS_SEARCH_REF);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.find_references_in_hierarchy_action");
    }

    QuerySpecification createQuery(IRubyElement element) throws RubyModelException {
        IType type = this.getType(element);
        if (type == null) {
            return super.createQuery(element);
        }
        RubySearchScopeFactory factory = RubySearchScopeFactory.getInstance();
        IRubySearchScope scope = SearchEngine.createHierarchyScope((IType)type);
        String description = factory.getHierarchyScopeDescription(type);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

