/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.search.RubySearchScopeFactory;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.ui.actions.FindDeclarationsAction;
import org.rubypeople.rdt.ui.search.ElementQuerySpecification;
import org.rubypeople.rdt.ui.search.QuerySpecification;

public class FindDeclarationsInProjectAction
extends FindDeclarationsAction {
    public FindDeclarationsInProjectAction(IWorkbenchSite site) {
        super(site);
    }

    public FindDeclarationsInProjectAction(RubyEditor editor) {
        super(editor);
    }

    void init() {
        this.setText(SearchMessages.Search_FindDeclarationsInProjectAction_label);
        this.setToolTipText(SearchMessages.Search_FindDeclarationsInProjectAction_tooltip);
        this.setImageDescriptor(RubyPluginImages.DESC_OBJS_SEARCH_DECL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.find_declarations_in_project_action");
    }

    QuerySpecification createQuery(IRubyElement element) throws RubyModelException {
        String description;
        IRubySearchScope scope;
        RubySearchScopeFactory factory = RubySearchScopeFactory.getInstance();
        RubyEditor editor = this.getEditor();
        boolean isInsideJRE = true;
        if (editor != null) {
            scope = factory.createRubyProjectSearchScope(editor.getEditorInput(), isInsideJRE);
            description = factory.getProjectScopeDescription(editor.getEditorInput(), isInsideJRE);
        } else {
            scope = factory.createRubyProjectSearchScope(element.getRubyProject(), isInsideJRE);
            description = factory.getProjectScopeDescription(element.getRubyProject(), isInsideJRE);
        }
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

